/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.project.examples.internal.model.JaxbParser;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleSite;

public class ProjectExampleSiteParser
extends JaxbParser {
    private static final JAXBContext jaxbContext;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SitesWrapper.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<IProjectExampleSite> parse(String xml) throws CoreException {
        if (xml == null || xml.trim().isEmpty()) {
            return null;
        }
        try {
            SitesWrapper siteList = (SitesWrapper)this.unmarshall(jaxbContext, xml);
            return siteList.sites == null ? Collections.emptySet() : siteList.sites;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.project.examples", "Unable to parse user example sites", (Throwable)e));
        }
    }

    public String serialize(Set<IProjectExampleSite> sites) throws CoreException {
        try {
            SitesWrapper siteList = new SitesWrapper();
            siteList.sites = sites;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)siteList, (Writer)writer);
            return writer.toString();
        }
        catch (Exception shouldntHappen) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.project.examples", "Unable to serialize example sites ", (Throwable)shouldntHappen));
        }
    }

    @XmlRootElement(name="sites")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class SitesWrapper {
        @XmlElement(name="site", type=ProjectExampleSite.class)
        Set<IProjectExampleSite> sites;

        SitesWrapper() {
        }
    }
}

