/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.fixes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.AbstractProjectFix;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.VersionRange;

public class PluginFix
extends AbstractProjectFix {
    PluginFix(ProjectExample project, RequirementModel fix) {
        super(project, fix);
    }

    @Override
    public boolean fix(IProgressMonitor monitor) {
        return false;
    }

    @Override
    public boolean isSatisfied() {
        String symbolicName = this.requirement.getProperties().get("id");
        if (symbolicName == null) {
            ProjectExamplesActivator.log(NLS.bind((String)Messages.PluginFix_Invalid_plugin_fix, (Object)this.project.getName()));
            return true;
        }
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle == null) {
            return false;
        }
        String versions = this.requirement.getProperties().get("versions");
        if (versions != null && !versions.isEmpty()) {
            VersionRange versionRange = new VersionRange(versions);
            return versionRange.includes(bundle.getVersion());
        }
        return true;
    }
}

