/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.devtools;

import com.sun.javafx.scene.web.Debugger;
import java.io.IOException;
import javafx.application.Platform;
import javafx.util.Callback;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.tools.browsersim.ui.devtools.DevToolsWebSocket;
import org.jboss.tools.browsersim.ui.devtools.DevToolsWebSocketServlet;
import org.jboss.tools.browsersim.ui.launch.BrowserSimArgs;

public class DevToolsDebuggerServer {
    private static ServletContextHandler contextHandler;
    private static Debugger debugger;
    private static Server server;

    public static void startDebugServer(Debugger debugger) throws Exception {
        server = new Server(BrowserSimArgs.debuggerPort);
        debugger.setEnabled(true);
        contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/");
        ServletHolder devToolsHolder = new ServletHolder((Servlet)new DevToolsWebSocketServlet());
        contextHandler.addServlet(devToolsHolder, "/devtools/page/dtdb");
        String devToolsPath = DevToolsDebuggerServer.class.getClassLoader().getResource("inspector-front-end").toExternalForm();
        ServletHolder devToolsHome = new ServletHolder("devTools-home", DefaultServlet.class);
        devToolsHome.setInitParameter("resourceBase", devToolsPath);
        devToolsHome.setInitParameter("dirAllowed", "true");
        contextHandler.addServlet(devToolsHome, "/");
        server.setHandler((Handler)contextHandler);
        server.start();
        DevToolsDebuggerServer.debugger = debugger;
        debugger.setMessageCallback((Callback)new Callback<String, Void>(){

            public Void call(String data) {
                DevToolsWebSocket mainSocket = (DevToolsWebSocket)contextHandler.getServletContext().getAttribute("org.jboss.tools.browsersim.ui.devtools.DevToolsWebSocket");
                if (mainSocket != null) {
                    try {
                        mainSocket.sendMessage(data);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public static void stopDebugServer() throws Exception {
        if (server != null) {
            server.stop();
            server.join();
        }
    }

    public static void sendMessageToBrowser(final String data) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                debugger.sendMessage(data);
            }
        });
    }

    public static String getServerState() {
        return server == null ? null : server.getState();
    }

    public static ServletContext getServletContext() {
        return contextHandler != null ? contextHandler.getServletContext() : null;
    }
}

