/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.FocusGainedTextListener;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.VerifyDigitsListener;
import org.jboss.tools.browsersim.ui.VerifyFloatListener;
import org.jboss.tools.browsersim.ui.model.Device;
import org.jboss.tools.browsersim.ui.model.SkinMap;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.browsersim.ui.util.BrowserSimImageList;

public abstract class DeviceDialog
extends Dialog {
    private static final String ERROR_IMAGE_PATH = "icons/error.gif";
    protected Device resultDevice;
    protected Device initialDevice;
    protected Shell shell;
    private Composite header;
    private Label statusImageLabel;
    private Text textStatus;
    private Text textName;
    private Text textWidth;
    private Text textHeight;
    private Text textPixelRatio;
    private Text textUserAgent;
    private Button checkButtonUserAgent;
    private Combo comboSkin;
    private Button buttonOk;
    private List<String> skinIds;
    private BrowserSimImageList imageList;

    public DeviceDialog(Shell parent, int style, Device initialDevice) {
        super(parent, style);
        this.setText(Messages.EditDeviceDialog_MANAGE_DEVICES);
        this.initialDevice = initialDevice;
    }

    public Device open() {
        this.createContents();
        this.shell.setSize(this.shell.computeSize(330, -1));
        this.shell.layout();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDevice;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getHeaderText());
        GridLayout shellLayout = new GridLayout(1, false);
        shellLayout.marginWidth = 0;
        shellLayout.marginHeight = 0;
        this.shell.setLayout((Layout)shellLayout);
        this.imageList = new BrowserSimImageList((Widget)this.shell);
        this.header = new Composite((Composite)this.shell, 0);
        this.header.setLayout((Layout)new GridLayout(2, false));
        this.header.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.header.setBackground(this.shell.getDisplay().getSystemColor(25));
        this.textStatus = new Text(this.header, 74);
        GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
        GC gc = new GC((Drawable)this.textStatus);
        try {
            gc.setFont(this.textStatus.getFont());
            FontMetrics fm = gc.getFontMetrics();
            data.heightHint = 2 * fm.getHeight() + 4;
        }
        finally {
            gc.dispose();
        }
        this.textStatus.setLayoutData((Object)data);
        this.textStatus.setBackground(this.textStatus.getDisplay().getSystemColor(25));
        this.textStatus.setText(this.getDefaultStatusText());
        Composite body = new Composite((Composite)this.shell, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label labelName = new Label(body, 0);
        labelName.setText(Messages.EditDeviceDialog_NAME);
        this.textName = new Text(body, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.addFocusListener((FocusListener)new FocusGainedTextListener());
        this.textName.setText(this.initialDevice.getName());
        this.textName.setFocus();
        Label labelWidth = new Label(body, 0);
        labelWidth.setText(Messages.EditDeviceDialog_WIDTH);
        this.textWidth = new Text(body, 2048);
        this.textWidth.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textWidth.setTextLimit(4);
        if (this.initialDevice.getWidth() != -1) {
            this.textWidth.setText(String.valueOf(this.initialDevice.getWidth()));
        }
        this.textWidth.addVerifyListener((VerifyListener)new VerifyDigitsListener());
        this.textWidth.addModifyListener((ModifyListener)new ModifySizeListener());
        this.textWidth.addFocusListener((FocusListener)new FocusGainedTextListener());
        Label labelHeight = new Label(body, 0);
        labelHeight.setText(Messages.EditDeviceDialog_HEIGHT);
        this.textHeight = new Text(body, 2048);
        this.textHeight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textHeight.setTextLimit(4);
        if (this.initialDevice.getHeight() != -1) {
            this.textHeight.setText(String.valueOf(this.initialDevice.getHeight()));
        }
        this.textHeight.addVerifyListener((VerifyListener)new VerifyDigitsListener());
        this.textHeight.addModifyListener((ModifyListener)new ModifySizeListener());
        this.textHeight.addFocusListener((FocusListener)new FocusGainedTextListener());
        Label labelPixelRatio = new Label(body, 0);
        labelPixelRatio.setText(Messages.EditDeviceDialog_PIXEL_RATIO);
        this.textPixelRatio = new Text(body, 2048);
        this.textPixelRatio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textPixelRatio.setTextLimit(5);
        this.textPixelRatio.setText(Device.PIXEL_RAIO_FORMAT.format(this.initialDevice.getPixelRatio()));
        this.textPixelRatio.addModifyListener((ModifyListener)new ModifySizeListener());
        this.textPixelRatio.addVerifyListener((VerifyListener)new VerifyFloatListener());
        this.checkButtonUserAgent = new Button(body, 32);
        this.checkButtonUserAgent.setText(Messages.EditDeviceDialog_USER_AGENT);
        this.checkButtonUserAgent.setSelection(this.initialDevice.getUserAgent() != null);
        this.textUserAgent = new Text(body, 2048);
        this.textUserAgent.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.initialDevice.getUserAgent() != null) {
            this.textUserAgent.setText(this.initialDevice.getUserAgent());
        }
        this.textUserAgent.addFocusListener((FocusListener)new FocusGainedTextListener());
        this.attachCheckBoxToText(this.checkButtonUserAgent, this.textUserAgent);
        Label labelSkin = new Label(body, 0);
        labelSkin.setText(Messages.EditDeviceDialog_SKIN);
        this.comboSkin = new Combo(body, 8);
        this.comboSkin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.skinIds = new ArrayList<String>(SkinMap.getInstance().getSkinIds());
        Collections.sort(this.skinIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        this.skinIds.add(0, Messages.EditDeviceDialog_NONE);
        this.comboSkin.setItems(this.skinIds.toArray(new String[0]));
        this.comboSkin.setText(this.initialDevice.getSkinId() == null ? Messages.EditDeviceDialog_NONE : this.initialDevice.getSkinId());
        this.comboSkin.addModifyListener((ModifyListener)new ModifySizeListener());
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(2, true));
        buttonsComposite.setLayoutData((Object)new GridData(131072, 1024, false, true, 1, 1));
        this.buttonOk = new Button(buttonsComposite, 0);
        this.buttonOk.setText(Messages.EditDeviceDialog_OK);
        this.buttonOk.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double pixelRatio;
                try {
                    pixelRatio = Device.PIXEL_RAIO_FORMAT.parse(DeviceDialog.this.textPixelRatio.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    pixelRatio = 1.0;
                }
                DeviceDialog.this.resultDevice = new Device(DeviceDialog.this.textName.getText(), Integer.valueOf("0" + DeviceDialog.this.textWidth.getText()), Integer.valueOf("0" + DeviceDialog.this.textHeight.getText()), pixelRatio, DeviceDialog.this.checkButtonUserAgent.getSelection() ? DeviceDialog.this.textUserAgent.getText() : null, DeviceDialog.this.comboSkin.getSelectionIndex() == 0 ? null : (String)DeviceDialog.this.skinIds.get(DeviceDialog.this.comboSkin.getSelectionIndex()));
                DeviceDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(this.buttonOk);
        Button buttonCancel = new Button(buttonsComposite, 0);
        buttonCancel.setText(Messages.EditDeviceDialog_CANCEL);
        buttonCancel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceDialog.this.resultDevice = null;
                DeviceDialog.this.shell.close();
            }
        });
    }

    private void showStatusImageLabel() {
        if (this.statusImageLabel == null || this.statusImageLabel.isDisposed()) {
            this.statusImageLabel = new Label(this.header, 0);
            this.statusImageLabel.setImage(this.imageList.getImage(ERROR_IMAGE_PATH));
            this.statusImageLabel.setBackground(this.shell.getDisplay().getSystemColor(25));
            this.statusImageLabel.moveAbove((Control)this.textStatus);
        }
    }

    private void hideStatusImageLabel() {
        if (this.statusImageLabel != null) {
            this.statusImageLabel.dispose();
        }
    }

    private void validate() {
        try {
            double pixelRatio = 0.0;
            try {
                pixelRatio = Device.PIXEL_RAIO_FORMAT.parse(this.textPixelRatio.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                this.setMessage(Messages.EditDeviceDialog_PIXEL_RATIO_ERROR);
                this.buttonOk.setEnabled(false);
                return;
            }
            if (pixelRatio == 0.0) {
                this.setMessage(Messages.EditDeviceDialog_ZERO_PIXEL_RATIO_ERROR);
                this.buttonOk.setEnabled(false);
                return;
            }
            BrowserSimSkin skin = SkinMap.getInstance().getSkinClass(this.comboSkin.getText()).newInstance();
            Point minimalSize = skin.getMinimalScreenSize();
            Point effectiveMinimalSize = new Point((int)((double)minimalSize.x * pixelRatio), (int)((double)minimalSize.y * pixelRatio));
            int width = 0;
            try {
                width = Integer.parseInt(this.textWidth.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(Messages.EditDeviceDialog_EMPTY_WIDTH_ERROR);
                this.buttonOk.setEnabled(false);
                return;
            }
            int height = 0;
            try {
                height = Integer.parseInt(this.textHeight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(Messages.EditDeviceDialog_EMPTY_HEIGHT_ERROR);
                this.buttonOk.setEnabled(false);
                return;
            }
            if (width < effectiveMinimalSize.x) {
                this.setMessage(MessageFormat.format(Messages.EditDeviceDialog_SMALL_WIDTH, effectiveMinimalSize.x, this.comboSkin.getText(), pixelRatio));
                this.buttonOk.setEnabled(false);
            } else if (height < effectiveMinimalSize.y) {
                this.setMessage(MessageFormat.format(Messages.EditDeviceDialog_SMALL_HEIGHT, effectiveMinimalSize.y, this.comboSkin.getText(), pixelRatio));
                this.buttonOk.setEnabled(false);
            } else {
                this.setMessage(null);
                this.buttonOk.setEnabled(true);
            }
        }
        catch (InstantiationException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
    }

    private void setMessage(String message) {
        if (message == null) {
            this.textStatus.setText(this.getDefaultStatusText());
            this.hideStatusImageLabel();
        } else {
            this.textStatus.setText(message);
            this.showStatusImageLabel();
        }
        this.header.layout();
    }

    protected abstract String getHeaderText();

    protected abstract String getDefaultStatusText();

    private void attachCheckBoxToText(Button checkBox, final Text text) {
        if (checkBox.getSelection()) {
            text.setEnabled(true);
        } else {
            text.setEnabled(false);
        }
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    text.setEnabled(true);
                } else {
                    text.setEnabled(false);
                }
            }
        });
    }

    final class ModifySizeListener
    implements ModifyListener {
        ModifySizeListener() {
        }

        public void modifyText(ModifyEvent e) {
            DeviceDialog.this.validate();
        }
    }
}

