/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.ui.internal.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;
import org.jboss.tools.maven.sourcelookup.ui.internal.Messages;

public class SourceLookupUtil {
    public static void attachSource(IPackageFragmentRoot fragment, IPath newSourcePath) {
        SourceLookupUtil.attachSource(fragment, newSourcePath, true);
    }

    public static void attachSource(final IPackageFragmentRoot fragment, final IPath newSourcePath, boolean displayDialog) {
        try {
            if (fragment == null || fragment.getKind() != 2) {
                return;
            }
            String value = SourceLookupActivator.getDefault().getAutoAddSourceAttachment();
            if ("never".equals(value)) {
                return;
            }
            if (displayDialog && "prompt".equals(value)) {
                final boolean[] attach = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        attach[0] = SourceLookupUtil.promptToAddSourceAttachment(fragment.getElementName(), newSourcePath.toString());
                    }
                });
                if (!attach[0]) {
                    return;
                }
            }
            IPath containerPath = null;
            IJavaProject jproject = fragment.getJavaProject();
            IClasspathEntry entry = fragment.getRawClasspathEntry();
            if (entry == null) {
                entry = JavaCore.newLibraryEntry((IPath)fragment.getPath(), null, null);
            } else if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
                if (initializer == null || container == null) {
                    return;
                }
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    return;
                }
                if (status.getCode() == 2) {
                    return;
                }
                entry = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)fragment.getPath());
                if (entry == null) {
                    return;
                }
            }
            CPListElement elem = CPListElement.createFromExisting((IClasspathEntry)entry, null);
            elem.setAttribute("sourcepath", (Object)newSourcePath);
            IClasspathEntry entry1 = elem.getClasspathEntry();
            if (entry1.equals(entry)) {
                return;
            }
            IClasspathEntry newEntry = entry1;
            String[] changedAttributes = new String[]{"sourcepath"};
            BuildPathSupport.modifyClasspathEntry(null, (IClasspathEntry)newEntry, (String[])changedAttributes, (IJavaProject)jproject, (IPath)containerPath, (newEntry.getReferencingEntry() != null ? 1 : 0) != 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    private static boolean promptToAddSourceAttachment(String jarName, String path) {
        String key;
        IPreferenceStore store = SourceLookupActivator.getDefault().getPreferenceStore();
        String value = store.getString(key = "autoAddProjectSourceAttachment");
        if ("always".equals(value)) {
            return true;
        }
        if ("never".equals(value)) {
            return false;
        }
        String title = NLS.bind((String)Messages.SourceLookupUtil_Found_Source_Title, (Object)jarName);
        String message = NLS.bind((String)Messages.SourceLookupUtil_Found_Source_Message, (Object)jarName, (Object)path);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)title, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)key);
        int result = dialog.getReturnCode();
        if (result == 1 || result == -1) {
            throw new OperationCanceledException();
        }
        return dialog.getReturnCode() == 2;
    }
}

