/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.ui.browsers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;
import org.jboss.tools.maven.sourcelookup.containers.JBossSourceContainer;
import org.jboss.tools.maven.sourcelookup.ui.SourceLookupUIActivator;
import org.jboss.tools.maven.sourcelookup.ui.browsers.JBossSourceContainerDialog;

public class JBossSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        JBossSourceContainerDialog dialog;
        ILaunchConfiguration configuration;
        ISourceContainer[] containers = new ISourceContainer[1];
        if (director != null && (configuration = director.getLaunchConfiguration()) != null) {
            try {
                if (SourceLookupActivator.isJBossAsLaunchConfiguration((ILaunchConfiguration)configuration)) {
                    containers[0] = new JBossSourceContainer(configuration);
                    return containers;
                }
            }
            catch (CoreException e) {
                SourceLookupUIActivator.log(e);
            }
        }
        if ((dialog = new JBossSourceContainerDialog(shell)).open() == 0 && dialog.getHomePath() != null) {
            containers[0] = new JBossSourceContainer(dialog.getHomePath());
            return containers;
        }
        return new ISourceContainer[0];
    }

    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        if (containers.length == 1 && "org.jboss.tools.maven.sourcelookup.containerType".equals(containers[0].getType().getId())) {
            ILaunchConfiguration configuration;
            if (director != null && (configuration = director.getLaunchConfiguration()) != null) {
                try {
                    if (SourceLookupActivator.isJBossAsLaunchConfiguration((ILaunchConfiguration)configuration)) {
                        return false;
                    }
                }
                catch (CoreException coreException) {}
            }
            return true;
        }
        return false;
    }

    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        JBossSourceContainerDialog dialog;
        if (containers.length == 1 && "org.jboss.tools.maven.sourcelookup.containerType".equals(containers[0].getType().getId()) && (dialog = new JBossSourceContainerDialog(shell)).open() == 0 && dialog.getHomePath() != null) {
            containers[0].dispose();
            containers[0] = new JBossSourceContainer(dialog.getHomePath());
            return containers;
        }
        return containers;
    }
}

