/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.cdi.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.jst.jee.util.internal.XMLRootHandler;
import org.xml.sax.InputSource;

public class BeansXmlQuickPeek {
    private static final String CDI_SCHEMA_ID_1_0 = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/beans_1_0.xsd";
    private static final String CDI_SCHEMA_ID_1_0_JBOSS = "http://java.sun.com/xml/ns/javaee http://docs.jboss.org/cdi/beans_1_0.xsd";
    private static final String CDI_SCHEMA_ID_1_1 = "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/beans_1_1.xsd";
    private static final String CDI_ID_1_0 = "1.0";
    private static final String CDI_ID_1_1 = "1.1";
    private XMLRootHandler handler;
    private String storedVersion;
    private boolean versionSet;

    public BeansXmlQuickPeek(IFile file) {
        block5: {
            this.storedVersion = null;
            this.versionSet = false;
            if (file == null) {
                throw new IllegalArgumentException("The file mustn't be null");
            }
            InputStream is = null;
            try {
                is = file.getContents();
                this.parse(is);
            }
            catch (Exception exception) {
                if (is == null) break block5;
                try {
                    is.close();
                }
                catch (Exception exception2) {}
            }
        }
    }

    public BeansXmlQuickPeek(InputStream in) {
        this.storedVersion = null;
        this.versionSet = false;
        this.parse(in);
    }

    private void parse(InputStream in) {
        block12: {
            if (in != null) {
                try {
                    try {
                        InputSource inputSource = new InputSource(in);
                        this.handler = new XMLRootHandler();
                        this.handler.parseContents(inputSource);
                    }
                    catch (Exception exception) {
                        try {
                            in.reset();
                        }
                        catch (IOException iOException) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.reset();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.reset();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getVersion() {
        if (!this.versionSet && this.handler != null && "beans".equals(this.handler.getRootName())) {
            String version = null;
            if (this.handler.getRootAttributes() != null) {
                version = this.handler.getRootAttributes().getValue("version");
            }
            if (version == null || version.trim().length() == 0) {
                version = this.getVersionFromSchema();
            }
            this.storedVersion = version;
            this.versionSet = true;
        }
        return this.storedVersion;
    }

    private String getVersionFromSchema() {
        if (this.handler == null) {
            return null;
        }
        String schemaName = null;
        if (this.handler.getRootAttributes() != null) {
            schemaName = JavaEEQuickPeek.normalizeSchemaLocation((String)this.handler.getRootAttributes().getValue("xsi:schemaLocation"));
        }
        if (schemaName == null) {
            return null;
        }
        String version = null;
        if (schemaName.equals(CDI_SCHEMA_ID_1_0) || schemaName.equals(CDI_SCHEMA_ID_1_0_JBOSS)) {
            version = CDI_ID_1_0;
        } else if (schemaName.equals(CDI_SCHEMA_ID_1_1)) {
            version = CDI_ID_1_1;
        }
        return version;
    }
}

