/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.internal;

import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.osgi.service.prefs.BackingStoreException;

public class RuntimeCorePreferences {
    private static final String ENABLED_DETECTORS = "enabledDetectors";
    private static final String DISABLED_DETECTORS = "disabledDetectors";
    private IEclipsePreferences prefs;
    private static RuntimeCorePreferences INSTANCE;

    public static RuntimeCorePreferences getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new RuntimeCorePreferences();
        }
        return INSTANCE;
    }

    public String[] getEnabledRuntimeDetectors() {
        String enabledDetectors = this.getPreferences().get(ENABLED_DETECTORS, null);
        return enabledDetectors == null ? null : enabledDetectors.split(",");
    }

    public String[] getDisabledRuntimeDetectors() {
        String disabledDetectors = this.getPreferences().get(DISABLED_DETECTORS, null);
        return disabledDetectors == null ? null : disabledDetectors.split(",");
    }

    @Deprecated
    public void saveEnabledDetectors() {
        this.saveDetectorEnablement();
    }

    public void saveDetectorEnablement() {
        this.saveDetectorEnablement(RuntimeCoreActivator.getDefault().getRuntimeDetectors());
    }

    public void saveDetectorEnablement(Set<IRuntimeDetector> detectors) {
        this.saveEnabledDetectors(detectors);
        this.saveDisabledDetectors(detectors);
    }

    private void saveDetectors(Set<IRuntimeDetector> allDetectors, String key, boolean enabled) {
        StringBuilder builder = new StringBuilder();
        for (IRuntimeDetector detector : allDetectors) {
            if ((!detector.isEnabled() || !enabled) && (detector.isEnabled() || enabled)) continue;
            builder.append(detector.getId());
            builder.append(",");
        }
        String toSave = builder.toString();
        int index = toSave.lastIndexOf(",");
        if (index != -1) {
            toSave = toSave.substring(0, index);
        }
        this.getPreferences().put(key, toSave);
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    public void saveEnabledDetectors(Set<IRuntimeDetector> allDetectors) {
        this.saveDetectors(allDetectors, ENABLED_DETECTORS, true);
    }

    public void saveDisabledDetectors(Set<IRuntimeDetector> allDetectors) {
        this.saveDetectors(allDetectors, DISABLED_DETECTORS, false);
    }

    IEclipsePreferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = ConfigurationScope.INSTANCE.getNode("org.jboss.tools.runtime.core");
        }
        return this.prefs;
    }
}

