/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.IUserPrompter;
import org.jboss.ide.eclipse.as.core.server.UserPrompter;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.Messages;
import org.jboss.ide.eclipse.as.wtp.core.Trace;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.AbstractJavaServerLaunchDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.ProcessTerminatedDebugListener;

public abstract class AbstractStartJavaServerLaunchDelegate
extends AbstractJavaServerLaunchDelegate {
    public static final String PROCESS = "AbstractStartJavaServerLaunchDelegate.Process";
    public static final String DEBUG_LISTENER = "AbstractStartJavaServerLaunchDelegate.DebugListener";
    public static final String NEXT_STOP_REQUIRES_FORCE = "DeployableServerBehavior.RequiresForceStop";
    public static final String HOTCODE_REPLACE_OVERRIDDEN = "AbstractStartJavaServerLaunchDelegate.HotCodeReplaceOverridden";
    private static final String PROCESS_TERMINATION_DELAY_PREF_KEY = "org.jboss.ide.eclipse.as.wtp.core.server.launch.PROCESS_TERMINATION_DELAY_PREF_KEY";

    protected int getProcessTerminationDelay() {
        return Platform.getPreferencesService().getInt("org.jboss.ide.eclipse.as.wtp.core", PROCESS_TERMINATION_DELAY_PREF_KEY, 10000, null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)server)) {
            return;
        }
        this.beforeVMRunner(configuration, mode, launch, monitor);
        this.actualLaunch(configuration, mode, launch, monitor);
        this.afterVMRunner(configuration, mode, launch, monitor);
    }

    protected void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fireVMRunner(configuration, mode, launch, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IStatus s = server.canStart(mode);
        Trace.trace("/finest", "Ensuring Server can start: " + s.getMessage());
        if (!s.isOK()) {
            throw new CoreException(s);
        }
        IControllableServerBehavior jbsBehavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)server)) {
            Trace.trace("/finest", "Server is marked as ignore Launch. Marking as started.");
            ((ControllableServerBehavior)jbsBehavior).setRunMode(mode);
            ((ControllableServerBehavior)jbsBehavior).setServerStarting();
            this.initiatePolling(server);
            return false;
        }
        this.validateServerStructure(server);
        Trace.trace("/finest", "Checking if similar server is already up on the same ports.");
        IStatus startedStatus = this.isServerStarted(server);
        boolean started = startedStatus.isOK();
        if (started) {
            Trace.trace("/finest", "A server is already started. Now handling the already started scenario.");
            return this.handleAlreadyStartedScenario(server, startedStatus);
        }
        Trace.trace("/finest", "A full launch will now proceed.");
        return true;
    }

    protected boolean handleAlreadyStartedScenario(IServer server, IStatus startedStatus) {
        Object ret = this.getPrompter().promptUser(101, server, startedStatus);
        if (ret instanceof Integer) {
            int handlerResult = (Integer)ret;
            if (handlerResult == 1) {
                return true;
            }
            if (handlerResult == 3) {
                return false;
            }
        }
        Trace.trace("/finest", "Either no handler available, or user selected continue. The server will be set to started automatically. ");
        IControllableServerBehavior jbsBehavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        ((ControllableServerBehavior)jbsBehavior).setServerStarted();
        return false;
    }

    public String[] getJavaLibraryPath(ILaunchConfiguration configuration) throws CoreException {
        return new String[0];
    }

    protected void beforeVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior(configuration);
        if (beh != null) {
            ((ControllableServerBehavior)beh).setRunMode(mode);
            ((ControllableServerBehavior)beh).setServerStarting();
        }
    }

    protected void afterVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProcess[] processes = launch.getProcesses();
        final IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior(configuration);
        if (processes != null && processes.length >= 1 && processes[0] != null) {
            ProcessTerminatedDebugListener debug = new ProcessTerminatedDebugListener(ServerUtil.getServer((ILaunchConfiguration)configuration), processes[0]){

                @Override
                protected void handleEarlyTermination() {
                    AbstractStartJavaServerLaunchDelegate.this.cancelPolling(server);
                    Status status = new Status(1, "org.jboss.ide.eclipse.as.wtp.core", 0x1030001, Messages.TERMINATED, null);
                    AbstractStartJavaServerLaunchDelegate.this.logStatus(server, (IStatus)status);
                }
            };
            if (beh != null) {
                final IProcess launched = processes[0];
                beh.putSharedData(PROCESS, launched);
                beh.putSharedData(DEBUG_LISTENER, debug);
                final IServer ser = beh.getServer();
                IServerListener list = new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        final 2 list2 = this;
                        int eventKind = event.getKind();
                        if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0 && ser.getServerState() == 4) {
                            new Thread(){

                                @Override
                                public void run() {
                                    Object result;
                                    try {
                                        Thread.sleep(AbstractStartJavaServerLaunchDelegate.this.getProcessTerminationDelay());
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    if (!launched.isTerminated() && ((result = AbstractStartJavaServerLaunchDelegate.this.getPrompter().promptUser(102, ser)) == null || result instanceof Boolean && ((Boolean)result).booleanValue())) {
                                        try {
                                            launched.terminate();
                                        }
                                        catch (DebugException de) {
                                            ASWTPToolsPlugin.log(de);
                                        }
                                    }
                                    ser.removeServerListener(list2);
                                }
                            }.start();
                        }
                    }
                };
                ser.addServerListener(list);
            }
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)debug);
        }
        this.initiatePolling(server);
    }

    protected IUserPrompter getPrompter() {
        return UserPrompter.getDefaultPrompter();
    }

    protected abstract void initiatePolling(IServer var1);

    protected abstract void cancelPolling(IServer var1);

    protected abstract void logStatus(IServer var1, IStatus var2);

    protected abstract IStatus isServerStarted(IServer var1);

    protected abstract void validateServerStructure(IServer var1) throws CoreException;

    @Override
    protected boolean overrideHotcodeReplace(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        boolean added = super.overrideHotcodeReplace(configuration, launch);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IControllableServerBehavior jbsBehavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (added) {
            jbsBehavior.putSharedData(HOTCODE_REPLACE_OVERRIDDEN, added);
        }
        return added;
    }
}

