/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanTypeEAP;

public class ServerBeanTypeEAP6
extends JBossServerType {
    private static final String EAP60_DIR_META_INF = "modules/org/jboss/as/product/eap/dir/META-INF";

    public ServerBeanTypeEAP6() {
        super("EAP", "Enterprise Application Platform", ServerBeanTypeEAP6.asPath("modules", "org", "jboss", "as", "server", "main"), new String[]{"6.0"}, new EAP6ServerTypeCondition());
    }

    public static class EAP6ServerTypeCondition
    extends ServerBeanTypeEAP.AbstractEAPTypeCondition {
        @Override
        public String getServerTypeId(String version) {
            return "org.jboss.ide.eclipse.as.eap.60";
        }

        @Override
        public boolean isServerRoot(File location) {
            return EAP6ServerTypeCondition.getEAP6xVersion(location, ServerBeanTypeEAP6.EAP60_DIR_META_INF, "6.", "eap", "EAP") != null;
        }

        @Override
        public String getFullVersion(File location, File systemJarFile) {
            return EAP6ServerTypeCondition.getEAP6xVersion(location, ServerBeanTypeEAP6.EAP60_DIR_META_INF, "6.", "eap", "EAP");
        }

        public static String getEAP6xVersion(File location, String metaInfPath, String versionPrefix, String slot, String releaseName) {
            Properties p;
            String product;
            Path rootPath = new Path(location.getAbsolutePath());
            IPath productConf = rootPath.append("bin/product.conf");
            if (productConf.toFile().exists() && slot.equals(product = (String)(p = JBossServerType.loadProperties(productConf.toFile())).get("slot"))) {
                return EAP6ServerTypeCondition.getEAP6xVersionNoSlotCheck(location, metaInfPath, versionPrefix, releaseName);
            }
            return null;
        }

        public static String getEAP6xVersionNoSlotCheck(File location, String metaInfPath, String versionPrefix, String releaseName) {
            Path rootPath = new Path(location.getAbsolutePath());
            IPath eapDir = rootPath.append(metaInfPath);
            if (eapDir.toFile().exists()) {
                boolean matchesVersion;
                IPath manifest = eapDir.append("MANIFEST.MF");
                Properties p2 = JBossServerType.loadProperties(manifest.toFile());
                String type = p2.getProperty("JBoss-Product-Release-Name");
                String version = p2.getProperty("JBoss-Product-Release-Version");
                boolean matchesName = releaseName == null || releaseName.equals(type);
                boolean bl = matchesVersion = versionPrefix == null || version.startsWith(versionPrefix);
                if (matchesName && matchesVersion) {
                    return version;
                }
            }
            return null;
        }
    }
}

