/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanExtensionManager;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanLoader {
    private ServerBean bean = null;
    private File rootLocation = null;
    @Deprecated
    public static JBossServerType[] typesInOrder = JBossServerType.KNOWN_TYPES;

    public ServerBeanLoader(File location) {
        this.rootLocation = location;
    }

    public ServerBean getServerBean() {
        if (this.bean == null) {
            this.loadBeanInternal();
        }
        return this.bean;
    }

    public ServerBeanType getServerBeanType() {
        if (this.bean == null) {
            this.loadBeanInternal();
        }
        return this.bean == null ? ServerBeanType.UNKNOWN : this.bean.getBeanType();
    }

    private void loadBeanInternal() {
        ServerBean server;
        ServerBeanType type = this.loadTypeInternal(this.rootLocation);
        String version = null;
        if (!ServerBeanType.UNKNOWN.equals(type)) {
            version = type.getFullVersion(this.rootLocation);
        }
        this.bean = server = new ServerBean(this.rootLocation.getPath(), type.getServerBeanName(this.rootLocation), type, version);
    }

    private ServerBeanType loadTypeInternal(File location) {
        ServerBeanType[] all = ServerBeanExtensionManager.getDefault().getAllTypes();
        int i = 0;
        while (i < all.length) {
            if (all[i].isServerRoot(location)) {
                return all[i];
            }
            ++i;
        }
        return ServerBeanType.UNKNOWN;
    }

    @Deprecated
    public String getName(File location) {
        return location.getName();
    }

    public String getFullServerVersion() {
        if (this.bean == null) {
            this.loadBeanInternal();
        }
        return this.bean.getFullVersion();
    }

    public String getUnderlyingTypeId() {
        if (this.bean == null) {
            this.loadBeanInternal();
        }
        return this.bean.getUnderlyingTypeId();
    }

    public String getServerAdapterId() {
        if (this.bean == null) {
            this.loadBeanInternal();
        }
        return this.bean.getServerAdapterTypeId();
    }

    public static String getFullServerVersionFromZip(File systemJarFile) {
        return AbstractCondition.getFullServerVersionFromZipLegacy(systemJarFile);
    }

    public static String getMajorMinorVersion(String version) {
        int secondDot;
        if (version == null) {
            return "";
        }
        int firstDot = version.indexOf(".");
        int n = secondDot = firstDot == -1 ? -1 : version.indexOf(".", firstDot + 1);
        if (secondDot != -1) {
            String currentVersion = version.substring(0, secondDot);
            return currentVersion;
        }
        if (firstDot != -1) {
            return version;
        }
        return "";
    }

    @Deprecated
    public static String getAdapterVersion(String version) {
        String pattern;
        String currentVersion;
        String[] versions;
        String[] stringArray = versions = JBossServerType.UNKNOWN.getVersions();
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            currentVersion = stringArray[n2];
            pattern = String.valueOf(currentVersion.replace(".", "\\.")) + ".*";
            if (version.matches(pattern)) {
                return currentVersion;
            }
            ++n2;
        }
        stringArray = versions;
        n = versions.length;
        n2 = 0;
        while (n2 < n) {
            currentVersion = stringArray[n2];
            pattern = String.valueOf(currentVersion.substring(0, 2).replace(".", "\\.")) + ".*";
            if (version.matches(pattern)) {
                return currentVersion;
            }
            ++n2;
        }
        return "";
    }

    @Deprecated
    public static String getServerVersion(String version) {
        if (version == null) {
            return "";
        }
        String adapterVersion = ServerBeanLoader.getAdapterVersion(version);
        boolean isEmpty = adapterVersion == null || "".equals(adapterVersion);
        return isEmpty ? ServerBeanLoader.getMajorMinorVersion(version) : adapterVersion;
    }

    @Deprecated
    public JBossServerType getServerType() {
        this.getServerBeanType();
        return this.bean == null ? JBossServerType.UNKNOWN : this.bean.getType();
    }
}

