/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForIDHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        String forID = this.getForId(region);
        IRegion elementByID = this.findElementByID(forID);
        if (elementByID != null) {
            StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)elementByID);
        } else {
            this.openFileFailed();
        }
    }

    private IRegion findElementByID(String id) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IDOMElement element = this.findElementByID(xmlDocument.getChildNodes(), id);
            if (element != null) {
                int offset = element.getStartOffset();
                int length = element.getStartStructuredDocumentRegion().getLength();
                Region region = new Region(offset, length);
                return region;
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private IDOMElement findElementByID(NodeList list, String id) {
        if (list == null || id == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n instanceof IDOMElement) {
                IDOMElement child;
                String val;
                IDOMElement element = (IDOMElement)n;
                Attr idAttr = element.getAttributeNode("id");
                if (idAttr != null && id.equals(val = this.trimQuotes(idAttr.getNodeValue()))) {
                    return element;
                }
                if (element.hasChildNodes() && (child = this.findElementByID(element.getChildNodes(), id)) != null) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    String getForId(IRegion region) {
        if (region == null) {
            return null;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        try {
            return this.trimQuotes(document.get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private String trimQuotes(String word) {
        if (word == null) {
            return null;
        }
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        return sb.substring(bStart, ++bEnd);
    }

    public String getHyperlinkText() {
        String forId = this.getForId(this.getHyperlinkRegion());
        if (forId == null) {
            return MessageFormat.format(Messages.BrowseFor, Messages.Id);
        }
        return MessageFormat.format(Messages.BrowseForId, forId);
    }
}

