/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ComboTools;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.BaseJoinColumnStateObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJoinColumnDialogPane<T extends BaseJoinColumnStateObject>
extends DialogPane<T> {
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public BaseJoinColumnDialogPane(PropertyValueModel<? extends T> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
        super(subjectModel, parentComposite, resourceManager);
    }

    private ModifiablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((BaseJoinColumnStateObject)((Object)this.subject)).setColumnDefinition(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultNameHolder() {
        return new TransformationPropertyValueModel<BaseJoinColumnStateObject, String>(this.getSubjectHolder()){

            protected String transform_(BaseJoinColumnStateObject value) {
                String name = value.getDefaultName();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private ListValueModel<String> buildDefaultNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultNameHolder());
    }

    private PropertyValueModel<String> buildDefaultReferencedColumnNameHolder() {
        return new TransformationPropertyValueModel<BaseJoinColumnStateObject, String>(this.getSubjectHolder()){

            protected String transform_(BaseJoinColumnStateObject value) {
                String name = value.getDefaultReferencedColumnName();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private ListValueModel<String> buildDefaultReferencedColumnNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultReferencedColumnNameHolder());
    }

    private PropertyValueModel<String> buildDefaultTableHolder() {
        return new TransformationPropertyValueModel<BaseJoinColumnStateObject, String>(this.getSubjectHolder()){

            protected String transform_(BaseJoinColumnStateObject value) {
                String name = value.getDefaultTable();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private ListValueModel<String> buildDefaultTableListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTableHolder());
    }

    private Transformer<String, String> buildDisplayableStringConverter(DefaultValueHandler handler) {
        return new DisplayableStringTransformer(handler);
    }

    private ModifiablePropertyValueModel<String> buildNameHolder() {
        return new PropertyAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).getName();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((BaseJoinColumnStateObject)((Object)this.subject)).setName(value);
            }
        };
    }

    private ListValueModel<String> buildNameListHolder() {
        return new ListAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"names"}){

            protected ListIterator<String> listIterator_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).names();
            }

            protected int size_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).columnsSize();
            }
        };
    }

    private ListValueModel<String> buildNamesListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultNameListHolder());
        holders.add(this.buildNameListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Transformer<String, String> buildNameStringConverter() {
        return this.buildDisplayableStringConverter(new DefaultValueHandler(){

            @Override
            public String getDefaultValue() {
                return ((BaseJoinColumnStateObject)BaseJoinColumnDialogPane.this.getSubject()).getDefaultName();
            }
        });
    }

    private ModifiablePropertyValueModel<String> buildReferencedColumnNameHolder() {
        return new PropertyAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"referencedColumnName"}){

            protected String buildValue_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).getReferencedColumnName();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((BaseJoinColumnStateObject)((Object)this.subject)).setReferencedColumnName(value);
            }
        };
    }

    private ListValueModel<String> buildReferencedColumnNameListHolder() {
        return new ListAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"referenceColumnNames"}){

            protected ListIterator<String> listIterator_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).referenceColumnNames();
            }

            protected int size_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).referenceColumnsSize();
            }
        };
    }

    private ListValueModel<String> buildReferencedColumnNamesListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultReferencedColumnNameListHolder());
        holders.add(this.buildReferencedColumnNameListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Transformer<String, String> buildReferencedColumnNameStringConverter() {
        return this.buildDisplayableStringConverter(new DefaultValueHandler(){

            @Override
            public String getDefaultValue() {
                return ((BaseJoinColumnStateObject)BaseJoinColumnDialogPane.this.getSubject()).getDefaultReferencedColumnName();
            }
        });
    }

    private ModifiablePropertyValueModel<String> buildTableHolder() {
        return new PropertyAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{"table"}){

            protected String buildValue_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).getTable();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((BaseJoinColumnStateObject)((Object)this.subject)).setTable(value);
            }
        };
    }

    private ListValueModel<String> buildTableListHolder() {
        return new ListAspectAdapter<BaseJoinColumnStateObject, String>(this.getSubjectHolder(), new String[]{""}){

            protected ListIterator<String> listIterator_() {
                return ((BaseJoinColumnStateObject)((Object)this.subject)).tables();
            }
        };
    }

    private ListValueModel<String> buildTablesListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTableListHolder());
        holders.add(this.buildTableListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Transformer<String, String> buildTableStringConverter() {
        return this.buildDisplayableStringConverter(new DefaultValueHandler(){

            @Override
            public String getDefaultValue() {
                return ((BaseJoinColumnStateObject)BaseJoinColumnDialogPane.this.getSubject()).getDefaultTable();
            }
        });
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 7, 0, 5);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_COLUMN_DIALOG_NAME);
        Combo nameCombo = this.addEditableCombo(container, this.buildNamesListHolder(), this.buildNameHolder(), this.buildNameStringConverter(), JpaHelpContextIds.MAPPING_JOIN_COLUMN_NAME);
        ComboTools.handleDefaultValue((Combo)nameCombo);
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_COLUMN_DIALOG_REFERENCED_COLUMN_NAME);
        Combo referencedColumnNameCombo = this.addEditableCombo(container, this.buildReferencedColumnNamesListHolder(), this.buildReferencedColumnNameHolder(), this.buildReferencedColumnNameStringConverter(), JpaHelpContextIds.MAPPING_JOIN_REFERENCED_COLUMN);
        ComboTools.handleDefaultValue((Combo)referencedColumnNameCombo);
        if (this.isTableEditable()) {
            this.addLabel(container, JptJpaUiDetailsMessages.JOIN_COLUMN_DIALOG_PANE_TABLE);
            Combo tableCombo = this.addEditableCombo(container, this.buildTablesListHolder(), this.buildTableHolder(), this.buildTableStringConverter(), JpaHelpContextIds.MAPPING_JOIN_REFERENCED_COLUMN);
            ComboTools.handleDefaultValue((Combo)tableCombo);
        } else {
            this.addLabel(container, JptJpaUiDetailsMessages.JOIN_COLUMN_DIALOG_PANE_TABLE);
            Combo tableCombo = this.addCombo(container, this.buildTablesListHolder(), this.buildTableHolder(), this.buildTableStringConverter(), JpaHelpContextIds.MAPPING_JOIN_REFERENCED_COLUMN);
            tableCombo.setEnabled(false);
        }
        this.addLabel(container, JptJpaUiDetailsMessages.JOIN_COLUMN_DIALOG_PANE_COLUMN_DEFINITION);
        this.addText(container, this.buildColumnDefinitionHolder());
    }

    protected boolean isTableEditable() {
        return false;
    }

    protected static interface DefaultValueHandler {
        public String getDefaultValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayableStringTransformer
    extends TransformerAdapter<String, String> {
        private final DefaultValueHandler handler;

        DisplayableStringTransformer(DefaultValueHandler handler) {
            this.handler = handler;
        }

        public String transform(String value) {
            if (BaseJoinColumnDialogPane.this.getSubject() == null) {
                return null;
            }
            if (value == null) {
                value = this.handler.getDefaultValue();
                value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
            }
            if (value.startsWith(DEFAULT_KEY)) {
                String defaultName = value.substring(DEFAULT_KEY.length());
                value = defaultName.length() > 0 ? NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultName) : JptCommonUiMessages.DEFAULT_EMPTY;
            }
            return value;
        }
    }
}

