/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchBuilder;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.core.jandex.JandexUtil;
import org.jboss.tools.common.util.FileUtil;

public class BatchArchiveDetector {
    public static final int UNRESOLVED = -1;
    public static final int NOT_ARCHIVE = 0;
    public static final int ARCHIVE = 1;
    static BatchArchiveDetector instance = new BatchArchiveDetector();
    boolean isLoaded = false;
    boolean isDirty = false;
    Map<String, Result> paths = new HashMap<String, Result>();
    static List<String> ARTIFACT_CLASSES = new ArrayList<String>();
    static List<String> ARTIFACT_INTERFACES = new ArrayList<String>();

    static {
        BatchArtifactType[] batchArtifactTypeArray = BatchArtifactType.values();
        int n = batchArtifactTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BatchArtifactType t = batchArtifactTypeArray[n2];
            String className = t.getClassName();
            if (className != null) {
                ARTIFACT_CLASSES.add(className);
            }
            if ((className = t.getInterfaceName()) != null) {
                ARTIFACT_INTERFACES.add(className);
            }
            ++n2;
        }
    }

    public static BatchArchiveDetector getInstance() {
        return instance;
    }

    private BatchArchiveDetector() {
    }

    public synchronized int getBatchArchive(String path) {
        this.load();
        if (!this.paths.containsKey(path)) {
            return -1;
        }
        int size = this.getSize(path);
        if (size != this.paths.get((Object)path).size) {
            this.paths.remove(path);
            this.isDirty = true;
            return -1;
        }
        return this.paths.get((Object)path).archive;
    }

    public synchronized void setBatchArchive(String path, int archive) {
        this.load();
        int size = this.getSize(path);
        if (size > 0) {
            this.paths.put(path, new Result(size, archive));
            this.isDirty = true;
        }
    }

    private int getSize(String path) {
        return this.getSize(new File(path));
    }

    private int getSize(File f) {
        if (f.isFile()) {
            return (int)f.length();
        }
        if (f.isDirectory()) {
            int result = 0;
            File[] fs = f.listFiles();
            if (fs != null) {
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File c = fileArray[n2];
                    result += this.getSize(c);
                    ++n2;
                }
            }
            return result;
        }
        return 0;
    }

    private synchronized void load() {
        if (this.isLoaded) {
            return;
        }
        try {
            File f = this.getStorageFile();
            if (f.isFile()) {
                String content = FileUtil.readFile((File)f);
                StringTokenizer st = new StringTokenizer(content, "\n");
                String path = null;
                int size = 0;
                int archive = -1;
                int c = 0;
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (c == 0 && t.startsWith("path=")) {
                        path = t.substring(5);
                        ++c;
                        continue;
                    }
                    if (c == 1 && t.startsWith("size=")) {
                        try {
                            size = Integer.parseInt(t.substring(5));
                            ++c;
                        }
                        catch (NumberFormatException e) {
                            BatchCorePlugin.pluginLog().logError((Throwable)e);
                        }
                        continue;
                    }
                    if (c != 2 || !t.startsWith("archive=")) continue;
                    try {
                        archive = Integer.parseInt(t.substring(8));
                        if (this.getSize(path) == size) {
                            this.paths.put(path, new Result(size, archive));
                        }
                        c = 0;
                    }
                    catch (NumberFormatException e) {
                        BatchCorePlugin.pluginLog().logError((Throwable)e);
                    }
                }
            }
        }
        finally {
            this.isLoaded = true;
        }
    }

    public synchronized void save() {
        if (this.isLoaded && this.isDirty) {
            this.isDirty = false;
            File f = this.getStorageFile();
            StringBuilder sb = new StringBuilder();
            for (String path : this.paths.keySet()) {
                Result r = this.paths.get(path);
                sb.append("path=").append(path).append("\n").append("size=").append(r.size).append("\n").append("archive=").append(r.archive).append("\n");
            }
            FileUtil.writeFile((File)f, (String)sb.toString());
        }
    }

    private File getStorageFile() {
        BatchCorePlugin plugin = BatchCorePlugin.getDefault();
        if (plugin != null) {
            IPath path = plugin.getStateLocation();
            File file = new File(path.toFile(), "bean-archives.txt");
            return file;
        }
        return null;
    }

    public int resolve(String jar, IBatchProject project) throws JavaModelException {
        IPackageFragmentRoot root;
        File jarFile = new File(jar);
        if (jarFile.isFile()) {
            if (this.computeIsJarBatchArchive(jarFile)) {
                this.setBatchArchive(jar, 1);
            } else {
                this.setBatchArchive(jar, 0);
            }
        } else if (jarFile.isDirectory() && (root = BatchArchiveDetector.findPackageFragmentRoot(jar, project)) != null && root.exists()) {
            if (this.hasBatchArtifcts(root, project)) {
                this.setBatchArchive(jar, 1);
            } else {
                this.setBatchArchive(jar, 0);
            }
        }
        return this.getBatchArchive(jar);
    }

    boolean hasBatchArtifcts(IPackageFragmentRoot root, IBatchProject project) throws JavaModelException {
        IJavaElement[] es;
        IJavaElement[] iJavaElementArray = es = root.getChildren();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement e = iJavaElementArray[n2];
            if (e instanceof IPackageFragment) {
                IClassFile[] cs;
                IPackageFragment pf = (IPackageFragment)e;
                IClassFile[] iClassFileArray = cs = pf.getClassFiles();
                int n3 = cs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClassFile c = iClassFileArray[n4];
                    if (BatchArchiveDetector.isBatchArtifact(c.getType(), project)) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isBatchArtifact(IType type, IBatchProject project) throws JavaModelException {
        TypeDefinition def = new TypeDefinition();
        def.setType(type, ((BatchProject)project).getDefinitions(), TypeDefinition.FLAG_NO_ANNOTATIONS);
        return def.getArtifactType() != null;
    }

    public static IPackageFragmentRoot findPackageFragmentRoot(String jar, IBatchProject project) {
        IJavaProject jp = EclipseUtil.getJavaProject((IProject)project.getProject());
        return jp == null ? null : BatchArchiveDetector.findPackageFragmentRoot(jar, jp);
    }

    public static IPackageFragmentRoot findPackageFragmentRoot(String jar, IProject project) {
        IJavaProject jp = EclipseUtil.getJavaProject((IProject)project);
        return jp == null ? null : BatchArchiveDetector.findPackageFragmentRoot(jar, jp);
    }

    public static IPackageFragmentRoot findPackageFragmentRoot(String jar, IJavaProject jp) {
        IPackageFragmentRoot root = jp.getPackageFragmentRoot(jar);
        if (root != null && !root.exists()) {
            IFile f = BatchBuilder.getFile(jar);
            if (f != null && f.exists()) {
                root = jp.getPackageFragmentRoot((IResource)f);
            } else {
                IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(new Path(String.valueOf(jar) + "/META-INF").makeAbsolute());
                if (c != null && c.exists()) {
                    root = jp.getPackageFragmentRoot((IResource)c.getParent());
                }
            }
        }
        return root;
    }

    boolean computeIsJarBatchArchive(File jarFile) {
        return JandexUtil.hasSubtypes((File)jarFile, ARTIFACT_CLASSES, ARTIFACT_INTERFACES);
    }

    static class Result {
        int size;
        int archive = -1;

        Result(int size, int archive) {
            this.size = size;
            this.archive = archive;
        }
    }
}

