/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.IRootDefinitionContext;
import org.jboss.tools.batch.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;

public class TypeDefinition
extends AbstractTypeDefinition {
    boolean isAbstract;
    List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    BatchArtifactType artifactType = null;

    @Override
    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        super.init(contextType, context, flags);
        boolean allMembers = (flags & FLAG_ALL_MEMBERS) > 0;
        boolean bl = this.isAbstract = Flags.isAbstract((int)this.type.getFlags()) || this.type.isInterface();
        if (this.isAbstract) {
            return;
        }
        IField[] fs = this.getType().getFields();
        int i = 0;
        while (i < fs.length) {
            FieldDefinition f = this.newFieldDefinition();
            f.setTypeDefinition(this);
            f.setField(fs[i], context, flags);
            if (allMembers || f.isBatchProperty()) {
                this.fields.add(f);
            }
            ++i;
        }
        Collection ts = this.getParametedType().getAllTypes();
        HashSet<String> typeNames = new HashSet<String>();
        for (IParametedType t : ts) {
            IType tp = t.getType();
            if (tp == null || !tp.exists()) continue;
            typeNames.add(tp.getFullyQualifiedName());
        }
        BatchArtifactType[] batchArtifactTypeArray = BatchArtifactType.values();
        int n = batchArtifactTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BatchArtifactType bat = batchArtifactTypeArray[n2];
            if (typeNames.contains(bat.getInterfaceName())) {
                this.artifactType = bat;
                break;
            }
            ++n2;
        }
    }

    protected FieldDefinition newFieldDefinition() {
        return new FieldDefinition();
    }

    public ParametedType getSuperType() {
        return this.parametedType == null ? null : this.parametedType.getSuperType();
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public BatchArtifactType getArtifactType() {
        return this.artifactType;
    }
}

