/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.BatchProjectChangeEvent;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProjectChangeListener;
import org.jboss.tools.batch.internal.core.impl.BatchArtifact;
import org.jboss.tools.batch.internal.core.impl.BatchBuilder;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.internal.core.impl.DefinitionContext;
import org.jboss.tools.batch.internal.core.impl.definition.BatchJobDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.BatchXMLDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.batch.internal.core.scanner.lib.ClassPathMonitor;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.jst.web.kb.internal.AbstractKbProjectExtension;
import org.jboss.tools.jst.web.kb.internal.IKbProjectExtension;

public class BatchProject
extends AbstractKbProjectExtension
implements IBatchProject {
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    DefinitionContext definitions = new DefinitionContext();
    ParametedTypeFactory typeFactory = new ParametedTypeFactory();
    private Set<IBatchArtifact> allArtifacts = new HashSet<IBatchArtifact>();
    private Map<IPath, Set<IBatchArtifact>> artifactsByPath = new HashMap<IPath, Set<IBatchArtifact>>();
    private Map<String, Set<IBatchArtifact>> artifactsByName = new HashMap<String, Set<IBatchArtifact>>();
    private Map<BatchArtifactType, Set<IBatchArtifact>> artifactsByType = new HashMap<BatchArtifactType, Set<IBatchArtifact>>();
    private Map<String, IBatchArtifact> artifactsByJavaType = new HashMap<String, IBatchArtifact>();
    private List<IBatchProjectChangeListener> listeners = new ArrayList<IBatchProjectChangeListener>();
    private static BatchBuildJob JOB = new BatchBuildJob();
    private static boolean suspended = false;
    static Collection<IBatchArtifact> EMPTY = Collections.EMPTY_SET;

    public BatchProject() {
        this.definitions.setProject(this);
    }

    protected void resolveUsedProjectInJob(IKbProjectExtension project) {
        JOB.add(project);
    }

    public boolean exists() {
        return this.getType("javax.batch.api.AbstractBatchlet") != null;
    }

    public List<TypeDefinition> getAllTypeDefinitions() {
        Set ps = this.getUsedProjects(true);
        if (ps == null || ps.isEmpty()) {
            return this.getDefinitions().getTypeDefinitions();
        }
        List<TypeDefinition> ds = this.getDefinitions().getTypeDefinitions();
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        result.addAll(ds);
        HashSet<IType> types = new HashSet<IType>();
        for (TypeDefinition d : ds) {
            IType t = d.getType();
            if (t == null) continue;
            types.add(t);
        }
        for (IKbProjectExtension p : ps) {
            List<TypeDefinition> ds2 = ((BatchProject)p).getDefinitions().getTypeDefinitions();
            for (TypeDefinition d : ds2) {
                IType t = d.getType();
                if (t == null || types.contains(t)) continue;
                types.add(t);
                result.add(d);
            }
        }
        return result;
    }

    public Set<BatchJobDefinition> getDeclaredBatchJobDefinitions() {
        return this.getDefinitions().getBatchJobDefinitions();
    }

    public Set<BatchJobDefinition> getAllBatchJobDefinitions() {
        if (!this.dependsOnOtherProjects()) {
            return this.getDeclaredBatchJobDefinitions();
        }
        Set<BatchJobDefinition> ds = this.getDefinitions().getBatchJobDefinitions();
        HashSet<BatchJobDefinition> result = new HashSet<BatchJobDefinition>();
        result.addAll(ds);
        HashSet<IPath> paths = new HashSet<IPath>();
        for (BatchJobDefinition d : ds) {
            IPath t = d.getPath();
            if (t == null) continue;
            paths.add(t);
        }
        for (BatchProject p : this.getBatchProjects(true)) {
            Set<BatchJobDefinition> ds2 = p.getDeclaredBatchJobDefinitions();
            for (BatchJobDefinition d : ds2) {
                IPath t = d.getPath();
                if (t == null || paths.contains(t)) continue;
                paths.add(t);
                result.add(d);
            }
        }
        return result;
    }

    public Set<BatchXMLDefinition> getDeclaredBatchXMLDefinitions() {
        return this.getDefinitions().getBatchXMLDefinitions();
    }

    public Set<BatchProject> getBatchProjects(boolean hierarchy) {
        if (hierarchy && this.dependsOnOtherProjects()) {
            HashSet<BatchProject> result = new HashSet<BatchProject>();
            this.getAllBatchProjects(result);
            return result;
        }
        return this.getBatchProjects();
    }

    synchronized void getAllBatchProjects(Set<BatchProject> result) {
        for (IKbProjectExtension n : this.dependsOn) {
            if (result.contains(n)) continue;
            result.add((BatchProject)n);
            ((BatchProject)n).getAllBatchProjects(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BatchProject> getBatchProjects() {
        HashSet<BatchProject> result = new HashSet<BatchProject>();
        BatchProject batchProject = this;
        synchronized (batchProject) {
            for (IKbProjectExtension n : this.dependsOn) {
                result.add((BatchProject)n);
            }
        }
        return result;
    }

    public ParametedTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    public void cleanTypeFactory() {
        BatchProject[] ps;
        this.typeFactory.clean();
        BatchProject[] batchProjectArray = ps = this.getAllDependentProjects();
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            BatchProject n3 = batchProjectArray[n2];
            n3.typeFactory.clean();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IBatchArtifact> getAllArtifacts() {
        HashSet<IBatchArtifact> result = new HashSet<IBatchArtifact>();
        BatchProject batchProject = this;
        synchronized (batchProject) {
            result.addAll(this.allArtifacts);
        }
        return result;
    }

    @Override
    public synchronized Collection<IBatchArtifact> getArtifacts(IResource resource) {
        Set<IBatchArtifact> result = this.artifactsByPath.get(resource.getFullPath());
        return result != null ? new HashSet<IBatchArtifact>(result) : EMPTY;
    }

    @Override
    public synchronized Set<IFile> getDeclaredBatchJobs() {
        HashSet<IFile> result = new HashSet<IFile>();
        for (BatchJobDefinition def : this.getDefinitions().getBatchJobDefinitions()) {
            result.add(def.getFile());
        }
        return result;
    }

    @Override
    public synchronized Collection<IBatchArtifact> getArtifacts(String name) {
        Set<IBatchArtifact> result = this.artifactsByName.get(name);
        return result != null ? new HashSet<IBatchArtifact>(result) : EMPTY;
    }

    @Override
    public synchronized Collection<IBatchArtifact> getArtifacts(BatchArtifactType type) {
        Collection result = this.artifactsByType.get(type);
        return result != null ? new HashSet(result) : EMPTY;
    }

    @Override
    public IBatchArtifact getArtifact(IType type) {
        return this.artifactsByJavaType.get(type.getFullyQualifiedName());
    }

    @Override
    public Collection<ITextSourceReference> getReferences(IType type) {
        HashSet<ITextSourceReference> result = new HashSet<ITextSourceReference>();
        for (IFile file : this.getDeclaredBatchJobs()) {
            result.addAll(BatchUtil.getAttributeReferences(file, "class", type.getFullyQualifiedName()));
        }
        return result;
    }

    public void store() throws IOException {
        this.isBuilt = true;
    }

    public boolean hasNoStorage() {
        if (this.isBuilt) {
            return false;
        }
        File f = null;
        return f == null || !f.exists();
    }

    protected void build() {
        try {
            new BatchBuilder(this);
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        this.isBuilt = false;
        this.classPath.clean();
        this.definitions.clean();
        BatchProject batchProject = this;
        synchronized (batchProject) {
            this.artifactsByPath.clear();
            this.artifactsByName.clear();
            this.artifactsByType.clear();
            this.artifactsByJavaType.clear();
            this.allArtifacts.clear();
        }
        this.postponeFiring();
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChanges() {
        IBatchProjectChangeListener[] ls = null;
        BatchProject batchProject = this;
        synchronized (batchProject) {
            ls = this.listeners.toArray(new IBatchProjectChangeListener[0]);
        }
        if (ls != null) {
            BatchProjectChangeEvent event = new BatchProjectChangeEvent();
            int i = 0;
            while (i < ls.length) {
                ls[i].projectChanged(event);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean updateDependent) {
        List<TypeDefinition> typeDefinitions = this.getAllTypeDefinitions();
        ArrayList<BatchArtifact> artifacts = new ArrayList<BatchArtifact>();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            BatchArtifact a = new BatchArtifact();
            a.setProject(this);
            a.setDefinition(typeDefinition);
            artifacts.add(a);
        }
        BatchProject batchProject = this;
        synchronized (batchProject) {
            this.artifactsByPath.clear();
            this.artifactsByName.clear();
            this.artifactsByType.clear();
            this.artifactsByJavaType.clear();
            this.allArtifacts.clear();
        }
        for (IBatchArtifact iBatchArtifact : artifacts) {
            this.addArtifact(iBatchArtifact);
        }
        if (updateDependent) {
            ArrayList arrayList = new ArrayList(this.usedBy);
            for (IKbProjectExtension p : arrayList) {
                p.update(false);
            }
        }
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifact(IBatchArtifact artifact) {
        this.addToMap(this.artifactsByName, artifact.getName(), artifact);
        this.addToMap(this.artifactsByType, artifact.getArtifactType(), artifact);
        this.addToMap(this.artifactsByPath, artifact.getSourcePath(), artifact);
        this.artifactsByJavaType.put(artifact.getType().getFullyQualifiedName(), artifact);
        BatchProject batchProject = this;
        synchronized (batchProject) {
            this.allArtifacts.add(artifact);
        }
    }

    private synchronized <P> void addToMap(Map<P, Set<IBatchArtifact>> map, P key, IBatchArtifact artifact) {
        if (key == null) {
            return;
        }
        Set<IBatchArtifact> bs = map.get(key);
        if (bs == null) {
            bs = new HashSet<IBatchArtifact>();
            map.put(key, bs);
        }
        bs.add(artifact);
    }

    public BatchProject[] getAllDependentProjects(boolean resolve) {
        HashMap<BatchProject, Integer> set = new HashMap<BatchProject, Integer>();
        this.getAllDependentProjects(set, 0);
        if (resolve) {
            for (BatchProject n : set.keySet()) {
                n.resolve();
            }
        }
        BatchProject[] result = set.keySet().toArray(new BatchProject[set.size()]);
        Arrays.sort(result, new D(set));
        return result;
    }

    public BatchProject[] getAllDependentProjects() {
        return this.getAllDependentProjects(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllDependentProjects(Map<BatchProject, Integer> result, int level) {
        if (level > 10) {
            return;
        }
        BatchProject[] array = null;
        BatchProject batchProject = this;
        synchronized (batchProject) {
            array = this.usedBy.toArray(new BatchProject[0]);
        }
        BatchProject[] batchProjectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            BatchProject n3 = batchProjectArray[n2];
            if (!result.containsKey(n3) || result.get(n3) < level) {
                result.put(n3, level);
                n3.getAllDependentProjects(result, level + 1);
            }
            ++n2;
        }
    }

    public DefinitionContext getDefinitions() {
        return this.definitions;
    }

    public void pathRemoved(IPath path) {
        this.definitions.getWorkingCopy().clean(path);
    }

    protected IKbProjectExtension loadWithFactory(IProject project, boolean resolve) {
        return BatchProjectFactory.getBatchProject(project, resolve);
    }

    @Override
    public synchronized void addBatchProjectListener(IBatchProjectChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeBatchProjectListener(IBatchProjectChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
        this.classPath.dispose();
        this.clean();
    }

    static class BatchBuildJob
    extends WorkspaceJob {
        List<IKbProjectExtension> list = new ArrayList<IKbProjectExtension>();
        boolean running = false;

        public BatchBuildJob() {
            super("Build Batch");
        }

        void add(IKbProjectExtension project) {
            if (!BatchBuildJob.isSuspended()) {
                if (this.list.contains(project)) {
                    return;
                }
                this.list.add(project);
                if (this.getState() == 0 || !this.isRunning()) {
                    this.schedule(0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            BatchBuildJob batchBuildJob = this;
            synchronized (batchBuildJob) {
                this.running = true;
            }
            while (true) {
                IKbProjectExtension r = null;
                BatchBuildJob batchBuildJob2 = this;
                synchronized (batchBuildJob2) {
                    if (this.list.size() == 0) {
                        this.running = false;
                        break;
                    }
                    r = this.list.remove(0);
                }
                if (monitor.isCanceled()) break;
                try {
                    r.resolve();
                    r.update(true);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    BatchCorePlugin.pluginLog().logError("Error in job ", (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void shutdown() {
            BatchBuildJob.setSuspended(true);
            BatchBuildJob batchBuildJob = JOB;
            synchronized (batchBuildJob) {
                JOB.list.clear();
            }
            if (JOB.isRunning()) {
                JOB.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRunning() {
            BatchBuildJob batchBuildJob = this;
            synchronized (batchBuildJob) {
                return this.running;
            }
        }

        public static boolean isSuspended() {
            return suspended;
        }

        public static void setSuspended(boolean suspended) {
            suspended = suspended;
        }
    }

    private static class D
    implements Comparator<BatchProject> {
        Map<BatchProject, Integer> set;

        D(Map<BatchProject, Integer> set) {
            this.set = set;
        }

        @Override
        public int compare(BatchProject o1, BatchProject o2) {
            return this.set.get(o1) - this.set.get(o2);
        }
    }
}

