/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.target.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.target.RuleBasedTargetPartitionScanner;
import org.jboss.ide.eclipse.freemarker.target.TargetLanguageSupport;
import org.jboss.ide.eclipse.freemarker.target.TargetPartitionScanner;
import org.jboss.ide.eclipse.freemarker.target.xml.XmlPartitionType;

public class XmlSupport
implements TargetLanguageSupport {
    public static final List<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".xml", ".html", ".xhtml", ".htm", ".xml.ftl", ".html.ftl", ".xhtml.ftl", ".htm.ftl"));

    @Override
    public ITokenScanner createColoringScanner(String partitionType) {
        XmlPartitionType xmlPartitionType = XmlPartitionType.fastValueOf(partitionType);
        if (xmlPartitionType != null) {
            return xmlPartitionType.createColoringTokenizer();
        }
        return null;
    }

    @Override
    public TargetPartitionScanner createPartitionScanner() {
        XmlPartitionType[] partitiontTypes = XmlPartitionType.values();
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>(partitiontTypes.length);
        XmlPartitionType[] xmlPartitionTypeArray = partitiontTypes;
        int n = partitiontTypes.length;
        int n2 = 0;
        while (n2 < n) {
            XmlPartitionType xmlPartitionType = xmlPartitionTypeArray[n2];
            IPredicateRule rule = xmlPartitionType.createPartitioningRule();
            if (rule != null) {
                rules.add(rule);
            }
            ++n2;
        }
        RuleBasedTargetPartitionScanner result = new RuleBasedTargetPartitionScanner();
        result.setDefaultReturnToken((IToken)new Token((Object)XmlPartitionType.OTHER.name()));
        result.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDocumentSupported(IEditorInput input) {
        if (!(input instanceof IStorageEditorInput)) return false;
        try {
            String suffix;
            IStorage storage = ((IStorageEditorInput)input).getStorage();
            String fileName = storage.getName();
            if (fileName == null) return false;
            fileName = fileName.toLowerCase(Locale.ENGLISH);
            Iterator<String> iterator = SUPPORTED_EXTENSIONS.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!fileName.endsWith(suffix = iterator.next()));
            return true;
        }
        catch (CoreException e) {
            Plugin.log(e);
        }
        return false;
    }
}

