/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.target;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.target.TargetLanguageSupport;
import org.jboss.ide.eclipse.freemarker.target.TargetPartitionScanner;

public class TargetColoringScanner
implements ITokenScanner {
    private TargetPartitionScanner partitionScanner;
    private TargetLanguageSupport targetLanguageSupport;
    private Map<String, ITokenScanner> coloringScanners;
    private ITokenScanner currentColoringScanner;
    private IDocument document;
    private final Editor editor;

    public TargetColoringScanner(Editor editor) {
        this.editor = editor;
        this.coloringScanners = new HashMap<String, ITokenScanner>();
    }

    private ITokenScanner getColoringScanner(String partitionType) {
        ITokenScanner result = this.coloringScanners.get(partitionType);
        if (result == null) {
            this.ensureInitialized();
            result = this.targetLanguageSupport.createColoringScanner(partitionType);
            this.coloringScanners.put(partitionType, result);
        }
        return result;
    }

    public int getTokenLength() {
        return this.currentColoringScanner.getTokenLength();
    }

    public int getTokenOffset() {
        return this.currentColoringScanner.getTokenOffset();
    }

    private ITokenScanner nextColoringScanner() {
        this.ensureInitialized();
        IToken token = this.partitionScanner.nextToken();
        if (token.isEOF()) {
            return this.partitionScanner;
        }
        ITokenScanner result = this.getColoringScanner((String)token.getData());
        result.setRange(this.document, this.partitionScanner.getTokenOffset(), this.partitionScanner.getTokenLength());
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextToken() {
        if (this.currentColoringScanner != this.partitionScanner) ** GOTO lbl6
        return Token.EOF;
lbl-1000:
        // 1 sources

        {
            this.currentColoringScanner = this.nextColoringScanner();
            if (this.currentColoringScanner != this.partitionScanner) continue;
            return Token.EOF;
lbl6:
            // 2 sources

            ** while ((coloringToken = this.currentColoringScanner.nextToken()).isEOF())
        }
lbl7:
        // 1 sources

        return coloringToken;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.ensureInitialized();
        this.document = document;
        this.partitionScanner.setPartialRange(document, offset, length, null, offset);
        this.currentColoringScanner = this.nextColoringScanner();
    }

    private void ensureInitialized() {
        if (this.targetLanguageSupport == null) {
            this.targetLanguageSupport = this.editor.getTargetLanguageSupport();
        }
        if (this.partitionScanner == null) {
            this.partitionScanner = this.targetLanguageSupport.createPartitionScanner();
        }
    }
}

