/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model.interpolation;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.model.interpolation.AbstractFragment;
import org.jboss.ide.eclipse.freemarker.model.interpolation.Fragment;

public class NameFragment
extends AbstractFragment {
    private Class<?> returnClass;
    private Class<?> singulaReturnClass;
    public static final String[] invalidMethods = new String[]{"clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"};

    public NameFragment(int offset, String content) {
        super(offset, content);
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int subOffset, int offset, Class<?> parentClass, List<Fragment> fragments, ISourceViewer sourceViewer, Map<String, Class<?>> context, IResource file, IProject project) {
        if (this.isStartFragment()) {
            String prefix = this.getContent().substring(0, subOffset);
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            for (String key : context.keySet()) {
                if (!key.startsWith(prefix)) continue;
                proposals.add(this.getCompletionProposal(offset, subOffset, key, this.getContent()));
            }
            return this.completionProposals(proposals);
        }
        if (parentClass == null) {
            return null;
        }
        return this.getMethodCompletionProposals(subOffset, offset, parentClass, file);
    }

    @Override
    public Class<?> getReturnClass(Class<?> parentClass, List<Fragment> fragments, Map<String, Class<?>> context, IResource resource, IProject project) {
        if (this.returnClass == null) {
            String content = this.getContent();
            if (this.isStartFragment()) {
                this.returnClass = context.get(content);
            } else if (parentClass == null) {
                this.returnClass = Object.class;
            } else {
                content = String.valueOf(Character.toUpperCase(content.charAt(1))) + content.substring(2, this.getContent().length());
                String getcontent = "get" + content;
                int i = 0;
                while (i < parentClass.getMethods().length) {
                    Method m = parentClass.getMethods()[i];
                    if (m.getName().equals(content) || m.getName().equals(getcontent)) {
                        this.returnClass = m.getReturnType();
                        break;
                    }
                    ++i;
                }
            }
        }
        return this.returnClass;
    }

    @Override
    public Class<?> getSingularReturnClass(Class<?> parentClass, List<Fragment> fragments, Map<String, Class<?>> context, IResource resource, IProject project) {
        if (this.singulaReturnClass == null) {
            String content = this.getContent();
            if (this.isStartFragment()) {
                ContextValue contextValue = ConfigurationManager.getInstance(project).getContextValue(content, resource, true);
                this.singulaReturnClass = contextValue == null || contextValue.singularClass == null ? Object.class : contextValue.singularClass;
            } else if (parentClass == null) {
                this.singulaReturnClass = Object.class;
            } else {
                content = String.valueOf(Character.toUpperCase(content.charAt(1))) + content.substring(2, this.getContent().length());
                String getcontent = "get" + content;
                int i = 0;
                while (i < parentClass.getMethods().length) {
                    Method m = parentClass.getMethods()[i];
                    if (m.getName().equals(content) || m.getName().equals(getcontent)) {
                        ParameterizedType pType;
                        Type type = m.getGenericReturnType();
                        if (type instanceof ParameterizedType && (pType = (ParameterizedType)type).getActualTypeArguments().length > 0) {
                            this.singulaReturnClass = (Class)pType.getActualTypeArguments()[0];
                            break;
                        }
                        this.singulaReturnClass = Object.class;
                        break;
                    }
                    ++i;
                }
            }
        }
        return this.singulaReturnClass;
    }

    public boolean isStartFragment() {
        return !this.getContent().startsWith(".");
    }

    public ICompletionProposal[] getMethodCompletionProposals(int subOffset, int offset, Class<?> parentClass, IResource file) {
        if (this.instanceOf(parentClass, String.class) || this.instanceOf(parentClass, Number.class) || this.instanceOf(parentClass, Date.class) || this.instanceOf(parentClass, Collection.class) || this.instanceOf(parentClass, List.class) || this.instanceOf(parentClass, Map.class)) {
            return null;
        }
        String prefix = this.getContent().substring(1, subOffset);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String pUpper = prefix.toUpperCase();
        try {
            BeanInfo bi = Introspector.getBeanInfo(parentClass);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                String propertyName = pd.getName();
                if (!propertyName.equals("class") && propertyName.toUpperCase().startsWith(pUpper)) {
                    proposals.add((ICompletionProposal)new CompletionProposal(propertyName, offset - subOffset + 1, this.getContent().length() - 1, propertyName.length(), null, String.valueOf(propertyName) + " - " + pd.getReadMethod().getReturnType().getName(), null, null));
                }
                ++i;
            }
            i = 0;
            while (i < parentClass.getMethods().length) {
                Method m = parentClass.getMethods()[i];
                String mName = m.getName();
                if (m.getParameterTypes().length > 0 && mName.startsWith("get") && mName.toUpperCase().startsWith(pUpper)) {
                    StringBuilder display = new StringBuilder();
                    display.append(mName);
                    display.append('(');
                    int j = 0;
                    while (j < m.getParameterTypes().length) {
                        if (j > 0) {
                            display.append(", ");
                        }
                        display.append(m.getParameterTypes()[j].getName());
                        ++j;
                    }
                    display.append(") - ").append(m.getReturnType().getName());
                    String actual = String.valueOf(mName) + "()";
                    int tLength = actual.length();
                    if (m.getParameterTypes().length > 0) {
                        --tLength;
                    }
                    proposals.add((ICompletionProposal)new CompletionProposal(actual, offset - subOffset + 1, this.getContent().length() - 1, tLength, null, display.toString(), null, null));
                }
                ++i;
            }
            return this.completionProposals(proposals);
        }
        catch (IntrospectionException e) {
            Plugin.log(e);
            return null;
        }
    }
}

