/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.FunctionDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemFactory;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;

public class ItemSet {
    private ISourceViewer viewer;
    private List<Item> directives;
    private List<Item> topLevelDirectives;
    private Map<Integer, Item> directiveRegions;
    private List<MacroDirective> macroDefinitions = new ArrayList<MacroDirective>();
    private List<Item> outlineItems = Collections.emptyList();

    public ItemSet(ISourceViewer viewer, List<ITypedRegion> regions, IResource resource) {
        this.viewer = viewer;
        ArrayList<Item> modifiableOutlineItems = new ArrayList<Item>();
        TreeMap<Integer, Item> modifiableDirectiveRegions = new TreeMap<Integer, Item>();
        try {
            this.directives = new ArrayList<Item>();
            this.topLevelDirectives = new ArrayList<Item>();
            Stack<Item> stackDirectives = new Stack<Item>();
            block4: for (ITypedRegion region : regions) {
                Item directive = ItemFactory.getItem(this, region, viewer, resource);
                if (directive == null) continue;
                if (directive instanceof MacroDirective) {
                    this.macroDefinitions.add((MacroDirective)directive);
                    modifiableOutlineItems.add(directive);
                }
                if (directive instanceof FunctionDirective) {
                    modifiableOutlineItems.add(directive);
                }
                if (stackDirectives.size() == 0) {
                    this.topLevelDirectives.add(directive);
                }
                modifiableDirectiveRegions.put(region.getOffset(), directive);
                if (!directive.isEndItem()) {
                    this.directives.add(directive);
                }
                if (!directive.isStartItem()) {
                    Item directiveCheck = ItemSet.getFirstNestableItem(stackDirectives);
                    if (directive.isStartAndEndItem()) {
                        if (directiveCheck != null && directiveCheck.isStartAndEndItem()) {
                            if (directiveCheck.relatesToItem(directive)) {
                                directiveCheck.relateItem(directive);
                                directive.relateItem(directiveCheck);
                            }
                            stackDirectives.pop();
                            directiveCheck = ItemSet.getFirstNestableItem(stackDirectives);
                        }
                        if ((directiveCheck = ItemSet.getFirstNestableItem(stackDirectives)) != null) {
                            directiveCheck.addSubDirective(directive);
                            directiveCheck.relateItem(directive);
                            directive.relateItem(directiveCheck);
                        }
                        stackDirectives.push(directive);
                        continue;
                    }
                    if (directiveCheck != null && directive.isEndItem() && directiveCheck.isStartAndEndItem()) {
                        if (directiveCheck.relatesToItem(directive)) {
                            directiveCheck.relateItem(directive);
                            directive.relateItem(directiveCheck);
                        }
                        stackDirectives.pop();
                        directiveCheck = ItemSet.getFirstNestableItem(stackDirectives);
                    }
                    if (directiveCheck != null && directiveCheck.relatesToItem(directive)) {
                        directiveCheck.relateItem(directive);
                        directive.relateItem(directiveCheck);
                        if (directive.isEndItem()) {
                            Item peek = stackDirectives.peek();
                            while (peek != null && peek.relatesToItem(directive)) {
                                if (peek.isStartItem()) {
                                    stackDirectives.pop();
                                    continue block4;
                                }
                                stackDirectives.pop();
                                Item item = peek = stackDirectives.size() > 0 ? stackDirectives.peek() : null;
                            }
                            continue;
                        }
                        directiveCheck.addSubDirective(directive);
                        stackDirectives.push(directive);
                        continue;
                    }
                    if (!directive.isNestable() && !directive.isEndItem()) {
                        if (directiveCheck == null) continue;
                        directiveCheck.addSubDirective(directive);
                        continue;
                    }
                    if (directive.isNestable() && !directive.isEndItem()) {
                        if (directiveCheck == null) continue;
                        directiveCheck.addSubDirective(directive);
                        stackDirectives.push(directive);
                        continue;
                    }
                    return;
                }
                if (stackDirectives.size() > 0) {
                    stackDirectives.peek().addSubDirective(directive);
                }
                if (!directive.isNestable()) continue;
                stackDirectives.push(directive);
            }
        }
        finally {
            this.outlineItems = Collections.unmodifiableList(modifiableOutlineItems);
            this.directiveRegions = Collections.unmodifiableMap(modifiableDirectiveRegions);
        }
        Collections.sort(this.macroDefinitions);
    }

    private static Item getFirstNestableItem(Stack<Item> stack) {
        if (stack.size() == 0) {
            return null;
        }
        ListIterator i = stack.listIterator(stack.size());
        while (i.hasPrevious()) {
            Item directiveCheck = (Item)i.previous();
            if (!directiveCheck.isNestable()) continue;
            return directiveCheck;
        }
        return null;
    }

    public Item[] getRootItems() {
        return this.topLevelDirectives.toArray(new Item[this.topLevelDirectives.size()]);
    }

    public List<Item> getOutlineItems() {
        return this.outlineItems;
    }

    public Map<Integer, Item> getDirectiveRegions() {
        return this.directiveRegions;
    }

    public Item getSelectedItem(int offset) {
        ITypedRegion region = this.getRegion(offset);
        if (region == null) {
            return null;
        }
        return this.directiveRegions.get(region.getOffset());
    }

    public Item getContextItem(int offset) {
        Item directive = this.getSelectedItem(offset);
        if (directive == null && this.directives != null) {
            Item dt = null;
            for (Item t : this.directives) {
                if (t.isNestable() && t.getRegion().getOffset() < offset) {
                    dt = t;
                    continue;
                }
                if (!t.isEndItem() || t.getRegion().getOffset() >= offset) continue;
                dt = null;
            }
            return dt;
        }
        return directive;
    }

    private ITypedRegion getRegion(int offset) {
        try {
            return TextUtilities.getPartition((IDocument)this.viewer.getDocument(), (String)"org.jboss.ide.eclipse.freemarker.partitioning", (int)offset, (boolean)false);
        }
        catch (BadLocationException e) {
            Plugin.log(e);
            return null;
        }
    }

    public List<MacroDirective> getMacroDefinitions() {
        return this.macroDefinitions;
    }

    public Item getPreviousItem(int offset) {
        Item item = this.getContextItem(offset);
        if (item == null) {
            for (Item itemSub : this.directives) {
                if (itemSub.getRegion().getOffset() + itemSub.getRegion().getOffset() >= offset) break;
                item = itemSub;
            }
        }
        return item;
    }

    public Item getPreviousStartItem(int offset) {
        Item item = null;
        for (Item itemSub : this.directives) {
            Item itemSub2;
            if (itemSub.getRegion().getOffset() > offset) break;
            if (!itemSub.isStartItem() || (itemSub2 = itemSub.getEndItem()) != null && itemSub2.getRegion().getOffset() <= offset) continue;
            item = itemSub;
        }
        return item;
    }

    public Item getItem(IRegion region) {
        return this.directiveRegions == null ? null : this.directiveRegions.get(region);
    }

    public Item getItem(int offset) {
        for (Item directive : this.directives) {
            ITypedRegion region = directive.getRegion();
            if (region.getOffset() > offset || region.getOffset() + region.getLength() < offset) continue;
            return directive;
        }
        return null;
    }
}

