/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.lang;

public enum SyntaxMode {
    SQUARE('[', ']'),
    ANGLE('<', '>');

    private final char start;
    private final char end;
    private final String commentStart;
    private final String commentEnd;
    private final String directiveStart;
    private final String directiveEnd;
    private final String macroInstanceStart;
    private final String macroInstanceEnd;
    private final String tagEnd;

    private SyntaxMode(char start, char end) {
        this.start = start;
        this.end = end;
        this.commentStart = new StringBuilder(4).append(start).append('#').append('-').append('-').toString();
        this.commentEnd = new StringBuilder(3).append('-').append('-').append(end).toString();
        this.directiveStart = new StringBuilder(2).append(start).append('#').toString();
        this.directiveEnd = new StringBuilder(3).append(start).append('/').append('#').toString();
        this.macroInstanceStart = new StringBuilder(2).append(start).append('@').toString();
        this.macroInstanceEnd = new StringBuilder(3).append(start).append('/').append('@').toString();
        this.tagEnd = String.valueOf(end);
    }

    public char getStart() {
        return this.start;
    }

    public char getEnd() {
        return this.end;
    }

    public String getCommentStart() {
        return this.commentStart;
    }

    public String getCommentEnd() {
        return this.commentEnd;
    }

    public String getDirectiveStart() {
        return this.directiveStart;
    }

    public String getDirectiveEnd() {
        return this.directiveEnd;
    }

    public String getMacroInstanceStart() {
        return this.macroInstanceStart;
    }

    public String getMacroInstanceEnd() {
        return this.macroInstanceEnd;
    }

    public String getTagEnd() {
        return this.tagEnd;
    }

    public static SyntaxMode getDefault() {
        return ANGLE;
    }
}

