/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.lang;

import org.jboss.ide.eclipse.freemarker.lang.LexicalConstants;

public class ParserUtils
implements LexicalConstants {
    public static final int INVALID_OFFSET = -1;
    private final CharSequence input;
    private final int inputLength;
    private int lastTokenStart;
    private int offset;

    public static boolean isBetween(char ch, char lower, char upper) {
        return ch >= lower && ch <= upper;
    }

    public static boolean isDigit(char ch) {
        return ParserUtils.isBetween(ch, '0', '9') || ParserUtils.isBetween(ch, '\u0660', '\u0669') || ParserUtils.isBetween(ch, '\u06f0', '\u06f9') || ParserUtils.isBetween(ch, '\u0966', '\u096f') || ParserUtils.isBetween(ch, '\u09e6', '\u09ef') || ParserUtils.isBetween(ch, '\u0a66', '\u0a6f') || ParserUtils.isBetween(ch, '\u0ae6', '\u0aef') || ParserUtils.isBetween(ch, '\u0b66', '\u0b6f') || ParserUtils.isBetween(ch, '\u0be7', '\u0bef') || ParserUtils.isBetween(ch, '\u0c66', '\u0c6f') || ParserUtils.isBetween(ch, '\u0ce6', '\u0cef') || ParserUtils.isBetween(ch, '\u0d66', '\u0d6f') || ParserUtils.isBetween(ch, '\u0e50', '\u0e59') || ParserUtils.isBetween(ch, '\u0ed0', '\u0ed9') || ParserUtils.isBetween(ch, '\u1040', '\u1049');
    }

    public static boolean isLetter(char ch) {
        return ch == '$' || ParserUtils.isBetween(ch, '@', 'Z') || ch == '_' || ParserUtils.isBetween(ch, 'a', 'z') || ParserUtils.isBetween(ch, '\u00c0', '\u00d6') || ParserUtils.isBetween(ch, '\u00d8', '\u00f6') || ParserUtils.isBetween(ch, '\u00f8', '\u00ff') || ParserUtils.isBetween(ch, '\u0100', '\u1fff') || ParserUtils.isBetween(ch, '\u3040', '\u318f') || ParserUtils.isBetween(ch, '\u3300', '\u337f') || ParserUtils.isBetween(ch, '\u3400', '\u3d2d') || ParserUtils.isBetween(ch, '\u4e00', '\u9fff') || ParserUtils.isBetween(ch, '\uf900', '\ufaff');
    }

    public static char getMatchingRightBracket(int leftBracket) {
        switch (leftBracket) {
            case 60: {
                return '>';
            }
            case 91: {
                return ']';
            }
        }
        throw new IllegalArgumentException("getMatchingEndCharacter() supported only for startCharacter '<' or '['.");
    }

    public static char getMatchingLeftBracket(int rightBracket) {
        switch (rightBracket) {
            case 62: {
                return '<';
            }
            case 93: {
                return '[';
            }
        }
        throw new IllegalArgumentException("getMatchingEndCharacter() supported only for startCharacter '<' or '['.");
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static boolean isClosingDirectiveBracket(char c) {
        return c == ']' || c == '>';
    }

    public ParserUtils(CharSequence input) {
        this(input, 0);
    }

    public ParserUtils(CharSequence input, int offset) {
        this.input = input;
        this.inputLength = input.length();
        this.offset = offset;
    }

    private void checkEndOfInput(String expected) throws ParseException {
        if (this.offset >= this.inputLength) {
            throw new ParseException("Unexpected end of input. " + expected + " expected.", this.offset);
        }
    }

    public int consumeIdentifier() throws ParseException {
        this.checkEndOfInput("identifier");
        this.lastTokenStart = this.offset;
        if (!ParserUtils.isLetter(this.input.charAt(this.offset))) {
            throw new ParseException("Letter expected at position " + this.offset, this.offset);
        }
        ++this.offset;
        while (this.offset < this.inputLength) {
            char ch = this.input.charAt(this.offset);
            if (!ParserUtils.isLetter(ch) && !ParserUtils.isDigit(ch)) break;
            ++this.offset;
        }
        return this.offset;
    }

    public int consumeStringLiteral() throws ParseException {
        this.checkEndOfInput("string literal");
        this.lastTokenStart = this.offset;
        char quot = this.input.charAt(this.offset);
        block0 : switch (quot) {
            case '\"': 
            case '\'': {
                ++this.offset;
                while (true) {
                    this.checkEndOfInput(String.valueOf(quot));
                    char ch = this.input.charAt(this.offset);
                    if (ch == quot) {
                        ++this.offset;
                        break block0;
                    }
                    if (ch != '\\') {
                        ++this.offset;
                        continue;
                    }
                    this.consumeEscapedChar();
                }
            }
            default: {
                throw new ParseException("Quotation mark or apostroph expected at position " + this.offset + ".", this.offset);
            }
        }
        return this.offset;
    }

    public int consumeRawString() throws ParseException {
        this.checkEndOfInput("raw string");
        this.lastTokenStart = this.offset;
        char r = this.input.charAt(this.offset);
        block0 : switch (r) {
            case 'r': {
                ++this.offset;
                this.checkEndOfInput("' or \"");
                char quot = this.input.charAt(this.offset);
                switch (quot) {
                    case '\"': 
                    case '\'': {
                        ++this.offset;
                        while (true) {
                            this.checkEndOfInput(String.valueOf(quot));
                            char ch = this.input.charAt(this.offset);
                            if (ch == quot) {
                                ++this.offset;
                                break block0;
                            }
                            ++this.offset;
                        }
                    }
                }
                throw new ParseException("Quotation mark or apostroph expected.", this.offset);
            }
            default: {
                throw new ParseException("Character 'r' expected.", this.offset);
            }
        }
        return this.offset;
    }

    public int consumeIdentifierOrStringLiteral() throws ParseException {
        this.checkEndOfInput("identifier or string literal");
        this.lastTokenStart = this.offset;
        switch (this.input.charAt(this.offset)) {
            case '\"': 
            case '\'': {
                return this.consumeStringLiteral();
            }
            case 'r': {
                if (this.offset + 1 >= this.inputLength) break;
                switch (this.input.charAt(this.offset)) {
                    case '\"': 
                    case '\'': {
                        return this.consumeRawString();
                    }
                }
            }
        }
        return this.consumeIdentifier();
    }

    public int consumeEscapedChar() throws ParseException {
        this.checkEndOfInput("escaped character");
        block0 : switch (this.input.charAt(this.offset)) {
            case '\\': {
                ++this.offset;
                this.checkEndOfInput("escaped character");
                switch (this.input.charAt(this.offset)) {
                    case '\"': 
                    case '$': 
                    case '\'': 
                    case '\\': 
                    case 'a': 
                    case 'b': 
                    case 'f': 
                    case 'g': 
                    case 'l': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case '{': {
                        ++this.offset;
                        break block0;
                    }
                    case 'x': {
                        ++this.offset;
                        this.checkEndOfInput("escaped character");
                        char ch = this.input.charAt(this.offset);
                        if (ParserUtils.isBetween(ch, '0', '9') || ParserUtils.isBetween(ch, 'a', 'f') || ParserUtils.isBetween(ch, 'A', 'F')) {
                            ++this.offset;
                            break block0;
                        }
                        throw new ParseException("0-9 or a-f or A-F expected at position " + this.offset + ".", this.offset);
                    }
                }
                throw new ParseException("A continuation of an escape sequence expected at position " + this.offset + ".", this.offset);
            }
            default: {
                throw new ParseException("Backslash expected at position " + this.offset + ".", this.offset);
            }
        }
        return this.offset;
    }

    public int consumeWhiteSpace() {
        this.lastTokenStart = this.offset;
        while (this.offset < this.inputLength) {
            switch (this.input.charAt(this.offset)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.offset;
                    break;
                }
                default: {
                    return this.offset;
                }
            }
        }
        return this.offset;
    }

    public CharSequence getLastToken() {
        if (this.lastTokenStart < 0) {
            throw new IllegalStateException();
        }
        return this.input.subSequence(this.lastTokenStart, this.offset);
    }

    public boolean isAtEndOfInput() {
        return this.offset >= this.inputLength;
    }

    public int match(String token) throws ParseException {
        this.lastTokenStart = this.offset;
        int i = 0;
        while (i < token.length()) {
            this.checkEndOfInput(token);
            char ch = this.input.charAt(this.offset);
            if (ch != token.charAt(i)) {
                throw new ParseException("Could not match token '" + token + "' at position " + this.offset + ".", this.offset);
            }
            ++this.offset;
            ++i;
        }
        return this.offset;
    }

    public boolean matches(char ch, boolean checkEndOfInput) throws ParseException {
        if (checkEndOfInput) {
            this.checkEndOfInput(String.valueOf(ch));
        }
        return this.input.charAt(this.offset) == ch;
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1718455070531564155L;
        private final int offset;

        public ParseException(String message, int offset) {
            super(message);
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

