/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.jboss.ide.eclipse.freemarker.editor.AnnotationHover;
import org.jboss.ide.eclipse.freemarker.editor.CompletionProcessor;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.editor.IncludeHyperlinkDetector;
import org.jboss.ide.eclipse.freemarker.editor.MacroHyperlinkDetector;
import org.jboss.ide.eclipse.freemarker.editor.ReconcilingStrategy;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;

public class Configuration
extends TextSourceViewerConfiguration {
    private Editor editor;

    public Configuration(IPreferenceStore preferenceStore, Editor editor) {
        super(preferenceStore);
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionType.PARTITION_TYPES;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.jboss.ide.eclipse.freemarker.partitioning";
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PartitionType[] partitionTypes;
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("org.jboss.ide.eclipse.freemarker.partitioning");
        PartitionType[] partitionTypeArray = partitionTypes = PartitionType.values();
        int n = partitionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PartitionType partitionType = partitionTypeArray[n2];
            ITokenScanner scanner = partitionType.createColoringTokenizer(this.editor);
            if (scanner != null) {
                DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
                reconciler.setDamager((IPresentationDamager)dr, partitionType.name());
                reconciler.setRepairer((IPresentationRepairer)dr, partitionType.name());
            }
            ++n2;
        }
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer aSourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        CompletionProcessor completionProcessor = new CompletionProcessor(this.editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
        PartitionType[] partitionTypeArray = PartitionType.values();
        int n = partitionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartitionType partitionType = partitionTypeArray[n2];
            assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, partitionType.name());
            ++n2;
        }
        assistant.enableAutoInsert(true);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        if (detectors == null) {
            detectors = new IHyperlinkDetector[]{};
        }
        IHyperlinkDetector[] detectorsNew = new IHyperlinkDetector[detectors.length + 2];
        System.arraycopy(detectors, 0, detectorsNew, 0, detectors.length);
        detectorsNew[detectorsNew.length - 2] = new IncludeHyperlinkDetector((ITextViewer)sourceViewer, this.editor);
        detectorsNew[detectorsNew.length - 1] = new MacroHyperlinkDetector((ITextViewer)sourceViewer, this.editor);
        return detectorsNew;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ReconcilingStrategy reconcilingStrategy = new ReconcilingStrategy(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)reconcilingStrategy, false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }
}

