/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesColumnTemplate
extends VpeAbstractTemplate {
    private static final String HEADER_ICON_STYLE = "vertical-align:middle;";
    private static final String SORTABLE_PATH = "column/sortable.gif";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        boolean visible = RichFacesColumnTemplate.isVisible(sourceElement);
        nsIDOMElement td = visualDocument.createElement("td");
        if (!visible) {
            VisualDomUtil.setSubAttribute((nsIDOMElement)td, (String)"style", (String)"display", (String)"none");
        }
        String columnClass = this.getColumnClass(sourceElement);
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)td);
        td.setAttribute("class", columnClass);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)td);
        Element headerFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"header");
        Element footerFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"footer");
        Map headerFacetChildren = VisualDomUtil.findFacetElements((Node)headerFacet, (VpePageContext)pageContext);
        Map footerFacetChildren = VisualDomUtil.findFacetElements((Node)footerFacet, (VpePageContext)pageContext);
        boolean headerHtmlElementPresents = ((List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        boolean footerHtmlElementPresents = ((List)footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        VpeChildrenInfo tdInfo = new VpeChildrenInfo(td);
        if (headerHtmlElementPresents) {
            for (Node child : (List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                tdInfo.addSourceChild(child);
            }
        }
        if (footerHtmlElementPresents) {
            for (Node child : (List)footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                tdInfo.addSourceChild(child);
            }
        }
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        for (Node child : children) {
            if (this.isFacet(child)) continue;
            tdInfo.addSourceChild(child);
        }
        creationData.addChildrenInfo(tdInfo);
        return creationData;
    }

    private boolean isFacet(Node child) {
        boolean ret = child.getNodeName().endsWith("facet");
        return ret;
    }

    private String getColumnClass(Element sourceElement) {
        String columnClass = this.isHeader(sourceElement) ? "dr-table-headercell rich-table-headercell" : (this.isFooter(sourceElement) ? "dr-table-footercell rich-table-footercell" : "dr-table-cell rich-table-cell");
        if (sourceElement.hasAttribute("styleClass")) {
            String styleClass = sourceElement.getAttribute("styleClass");
            columnClass = String.valueOf(columnClass) + " " + styleClass;
        }
        return columnClass;
    }

    private boolean isHeader(Element sourceElement) {
        return this.icludedInFacet(sourceElement, "header");
    }

    private boolean isFooter(Element sourceElement) {
        return this.icludedInFacet(sourceElement, "footer");
    }

    private boolean icludedInFacet(Element sourceElement, String facetName) {
        Node parent = sourceElement.getParentNode();
        if (parent != null) {
            if (ComponentUtil.isFacet(parent, facetName)) {
                return true;
            }
            if (parent.getNodeName().endsWith("columnGroup")) {
                return ComponentUtil.isFacet(parent.getParentNode(), facetName);
            }
        }
        return false;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        VpeDomMapping domMapping = pageContext.getDomMapping();
        SourceDomUtil.getParentHavingDomMapping((Node)sourceNode, (VpeDomMapping)domMapping);
        Node parent = SourceDomUtil.getParentHavingDomMapping((Node)sourceNode, (VpeDomMapping)domMapping);
        if (parent != null) {
            return parent;
        }
        return sourceNode;
    }

    public static nsIDOMElement getHeaderIcon(VpePageContext pageContext, Element column, nsIDOMDocument visualDocument) {
        String sortable = ComponentUtil.getAttribute(column, "sortable");
        if ("true".equals(sortable) || column.hasAttribute("sortBy")) {
            nsIDOMElement img = visualDocument.createElement("img");
            if (column.hasAttribute("sortIcon")) {
                String sortIcon = column.getAttribute("sortIcon");
                sortIcon = VpeStyleUtil.addFullPathToImgSrc((String)sortIcon, (VpePageContext)pageContext, (boolean)true);
                sortIcon = sortIcon.replace('\\', '/');
                img.setAttribute("src", sortIcon);
            } else {
                ComponentUtil.setImg(img, SORTABLE_PATH);
            }
            img.setAttribute("style", HEADER_ICON_STYLE);
            return img;
        }
        return null;
    }

    public static boolean isBreakBefore(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String breakBeforeVal = element.getAttribute("breakBefore");
            String brealRowBeforeVal = element.getAttribute("breakRowBefore");
            return "true".equals(breakBeforeVal) || "true".equals(brealRowBeforeVal);
        }
        return false;
    }

    public static boolean isVisible(Element column) {
        return !"false".equals(column.getAttribute("visible"));
    }
}

