/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesColorPickerTemplate
extends VpeAbstractTemplate {
    private static final String COLOR_PICKER_CSS_STYLE_PATH = "colorPicker/colorPicker.css";
    private static final String COLOR_PICKER_COMPONENT_NAME = "colorPicker";
    private static final String COLOR_PICKER_ANGLE_ARROW_ICON_PATH = "/colorPicker/colorPickerAngleArrow.gif";
    private static final String CSS_SPAN = "rich-color-picker-span";
    private static final String CSS_ICON = "rich-color-picker-icon";
    private static final String ATTR_COLOR_MODE = "colorMode";
    private static final String VALUE_COLOR_MODE_RGB = "rgb";
    private static final String DEFAULT_COLOR_PICKER_VALUE_HEX = "#ffffff";
    private static final String DEFAULT_COLOR_PICKER_VALUE_RGB = "rgb(255, 255, 255)";
    private static final String DEFAULT_COLOR_PICKER_ICON_STYLE = "background-color: rgb(255, 255, 255);";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, COLOR_PICKER_CSS_STYLE_PATH, COLOR_PICKER_COMPONENT_NAME);
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement span = visualDocument.createElement("span");
        nsIDOMElement input = visualDocument.createElement("input");
        nsIDOMElement img = visualDocument.createElement("img");
        span.appendChild((nsIDOMNode)input);
        span.appendChild((nsIDOMNode)img);
        span.setAttribute("class", CSS_SPAN);
        String defaultColorMode = DEFAULT_COLOR_PICKER_VALUE_HEX;
        if (sourceElement.hasAttribute(ATTR_COLOR_MODE) && VALUE_COLOR_MODE_RGB.equalsIgnoreCase(sourceElement.getAttribute(ATTR_COLOR_MODE))) {
            defaultColorMode = DEFAULT_COLOR_PICKER_VALUE_RGB;
        }
        input.setAttribute("value", defaultColorMode);
        input.setAttribute("type", "text");
        input.setAttribute("readonly", "readonly");
        img.setAttribute("class", CSS_ICON);
        img.setAttribute("style", DEFAULT_COLOR_PICKER_ICON_STYLE);
        ComponentUtil.setImg(img, COLOR_PICKER_ANGLE_ARROW_ICON_PATH);
        VpeCreationData creationData = VisualDomUtil.createTemplateWithTextContainer((Element)sourceElement, (nsIDOMElement)span, (String)"span", (nsIDOMDocument)visualDocument);
        return creationData;
    }
}

