/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.AbstractEditableRichFacesTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.AttributeData;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMHTMLInputElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InputNumberSliderTemplate
extends AbstractEditableRichFacesTemplate {
    private static final String STYLE_PATH = "/inputNumberSlider/numberSlider.css";
    private static final String SPACER_IMAGE_PATH = "/inputNumberSlider/spacer.gif";
    private static final String SHOW_INPUT_ATTR = "showInput";
    private static final String SHOW_BOUNDARY_VALUES = "showBoundaryValues";
    private static final String INPUT_POSITION_ATTR = "inputPosition";
    private static final String MIN_VALUE_ATTR = "minValue";
    private static final String MAX_VALUE_ATTR = "maxValue";
    private static final String BAR_STYLE_ATTR = "barStyle";
    private static final String MIN_VALUE_DEFAULT = "0";
    private static final String MAX_VALUE_DEFAULT = "100";
    private static final String INPUT_SIZE_DEFAULT = "3";
    private static final String SLYDER_WIDTH_DEFAULT = "200";
    private static final String INPUT_FIELD_STYLE = "text-align: left; vertical-align: bottom;";
    private static final String SPACER_IMAGE_STYLE = "display: block;";
    private static final String HANDLER_WRAPPER_STYLE = "position: relative;";
    private static final String HANDLER_STYLE = "visibility: visible;";
    private static final Map<String, String> defaultStyleClasses = new HashMap<String, String>();
    private static final String MIN_VALUE_STYLE_CLASSES = "dr-insldr-left-num rich-inslider-left-num";
    private static final String MAX_VALUE_STYLE_CLASSES = "dr-insldr-right-num rich-inslider-right-num";
    private static final String INPUT_LEFT_STYLE_CLASSES = "dr-insldr-field dr-insldr-field-left";
    private static final String INPUT_RIGHT_STYLE_CLASSES = "dr-insldr-field dr-insldr-field-right";
    private static final String SLIDER_STYLE_CLASSES = "dr-insldr-size dr-insldr-vert-spacer";
    private static final String TRACK_DECOR_1_CLASSES = "dr-insldr-track-decor-1";
    private static final String TRACK_DECOR_2_CLASSES = "dr-insldr-track-decor-2";
    private static final Map<String, String> styleClasses;

    static {
        defaultStyleClasses.put("style", "dr-insldr rich-slider");
        defaultStyleClasses.put("input", "rich-inslider-field");
        defaultStyleClasses.put("bar", "dr-insldr-track rich-inslider-track");
        defaultStyleClasses.put("handle", "dr-insldr-handler rich-inslider-handler");
        styleClasses = new HashMap<String, String>();
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, "inputNumberSlider");
        Element sourceElement = (Element)sourceNode;
        this.prepareData(sourceElement);
        nsIDOMElement basicTable = visualDocument.createElement("table");
        String style = "width:" + this.getNumberValue(sourceElement, "width", SLYDER_WIDTH_DEFAULT) + "px;" + this.getAttribute(sourceElement, "style") + ";";
        basicTable.setAttribute("style", style);
        basicTable.setAttribute("class", styleClasses.get("style"));
        basicTable.setAttribute("cellpadding", MIN_VALUE_DEFAULT);
        basicTable.setAttribute("cellspacing", MIN_VALUE_DEFAULT);
        basicTable.setAttribute("border", MIN_VALUE_DEFAULT);
        VpeElementData elementData = new VpeElementData();
        nsIDOMElement valuesBlock = this.createValuesBlock(sourceElement, visualDocument, elementData);
        nsIDOMElement sliderBlock = this.createSliderBlock(sourceElement, visualDocument);
        basicTable.appendChild((nsIDOMNode)valuesBlock);
        basicTable.appendChild((nsIDOMNode)sliderBlock);
        VpeCreationData creationData = VisualDomUtil.createTemplateWithTextContainer((Element)sourceElement, (nsIDOMElement)basicTable, (String)"div", (nsIDOMDocument)visualDocument);
        creationData.setElementData(elementData);
        return creationData;
    }

    private void prepareData(Element sourceElement) {
        Set<String> styleClassesKeys = defaultStyleClasses.keySet();
        styleClasses.clear();
        for (String key : styleClassesKeys) {
            if (sourceElement.hasAttribute(String.valueOf(key) + "Class")) {
                styleClasses.put(key, String.valueOf(defaultStyleClasses.get(key)) + " " + sourceElement.getAttribute(String.valueOf(key) + "Class"));
                continue;
            }
            styleClasses.put(key, defaultStyleClasses.get(key));
        }
    }

    private nsIDOMElement createValuesBlock(Element sourceElement, nsIDOMDocument visualDocument, VpeElementData elementData) {
        nsIDOMElement valuesBlock = visualDocument.createElement("tr");
        nsIDOMElement minValueTD = visualDocument.createElement("td");
        minValueTD.setAttribute("class", MIN_VALUE_STYLE_CLASSES);
        nsIDOMElement maxValueTD = visualDocument.createElement("td");
        maxValueTD.setAttribute("class", MAX_VALUE_STYLE_CLASSES);
        if (this.isShowBoundaryValues(sourceElement)) {
            Object minValueData = null;
            nsIDOMText minValueText = visualDocument.createTextNode(this.getNumberValue(sourceElement, MIN_VALUE_ATTR, MIN_VALUE_DEFAULT));
            minValueData = sourceElement.hasAttribute(MIN_VALUE_ATTR) ? new NodeData((Node)sourceElement.getAttributeNode(MIN_VALUE_ATTR), (nsIDOMNode)minValueText) : new AttributeData(MIN_VALUE_ATTR, (nsIDOMNode)minValueText);
            minValueTD.appendChild((nsIDOMNode)minValueText);
            elementData.addNodeData((NodeData)minValueData);
            nsIDOMText maxValueText = visualDocument.createTextNode(this.getNumberValue(sourceElement, MAX_VALUE_ATTR, MAX_VALUE_DEFAULT));
            Object maxValueData = sourceElement.hasAttribute(MAX_VALUE_ATTR) ? new NodeData((Node)sourceElement.getAttributeNode(MAX_VALUE_ATTR), (nsIDOMNode)maxValueText) : new AttributeData(MAX_VALUE_ATTR, (nsIDOMNode)maxValueText);
            maxValueTD.appendChild((nsIDOMNode)maxValueText);
            elementData.addNodeData((NodeData)maxValueData);
        }
        valuesBlock.appendChild((nsIDOMNode)minValueTD);
        valuesBlock.appendChild((nsIDOMNode)maxValueTD);
        if (this.isShowInput(sourceElement)) {
            nsIDOMElement inputTd = this.createInputBlock(sourceElement, visualDocument, elementData);
            if (this.isRightInputPosition(sourceElement)) {
                valuesBlock.appendChild((nsIDOMNode)inputTd);
            } else {
                valuesBlock.insertBefore((nsIDOMNode)inputTd, (nsIDOMNode)minValueTD);
            }
        }
        return valuesBlock;
    }

    private nsIDOMElement createInputBlock(Element sourceElement, nsIDOMDocument visualDocument, VpeElementData elementData) {
        nsIDOMElement inputTD = visualDocument.createElement("td");
        inputTD.setAttribute("style", INPUT_FIELD_STYLE);
        inputTD.setAttribute("rowspan", "2");
        nsIDOMElement inputField = visualDocument.createElement("input");
        inputField.setAttribute("type", "text");
        inputField.setAttribute("size", this.getNumberValue(sourceElement, "inputSize", INPUT_SIZE_DEFAULT));
        inputField.setAttribute("style", this.getAttribute(sourceElement, "inputStyle"));
        Object attributeData = null;
        inputField.setAttribute("value", ComponentUtil.getAttribute(sourceElement, "value"));
        attributeData = sourceElement.hasAttribute("value") ? new NodeData((Node)sourceElement.getAttributeNode("value"), (nsIDOMNode)inputField) : new AttributeData("value", (nsIDOMNode)inputField);
        elementData.addNodeData((NodeData)attributeData);
        String inputClass = null;
        inputClass = this.isRightInputPosition(sourceElement) ? INPUT_RIGHT_STYLE_CLASSES : INPUT_LEFT_STYLE_CLASSES;
        inputClass = inputClass + " " + styleClasses.get("input");
        inputField.setAttribute("class", inputClass);
        nsIDOMHTMLInputElement iDOMInputElement = (nsIDOMHTMLInputElement)XPCOM.queryInterface((nsISupports)inputField, nsIDOMHTMLInputElement.class);
        iDOMInputElement.setReadOnly(false);
        inputTD.appendChild((nsIDOMNode)inputField);
        return inputTD;
    }

    private nsIDOMElement createSliderBlock(Element sourceElement, nsIDOMDocument visualDocument) {
        nsIDOMElement sliderBlock = visualDocument.createElement("tr");
        nsIDOMElement sliderTD = visualDocument.createElement("td");
        sliderTD.setAttribute("class", SLIDER_STYLE_CLASSES);
        sliderTD.setAttribute("colspan", "2");
        nsIDOMElement handlerWrapper = visualDocument.createElement("div");
        handlerWrapper.setAttribute("style", HANDLER_WRAPPER_STYLE);
        nsIDOMElement handler = visualDocument.createElement("div");
        handler.setAttribute("style", HANDLER_STYLE);
        handler.setAttribute("class", styleClasses.get("handle"));
        handlerWrapper.appendChild((nsIDOMNode)handler);
        nsIDOMElement barDiv = visualDocument.createElement("div");
        barDiv.setAttribute("style", ComponentUtil.getAttribute(sourceElement, BAR_STYLE_ATTR));
        barDiv.setAttribute("class", styleClasses.get("bar"));
        nsIDOMElement barTable = visualDocument.createElement("table");
        barTable.setAttribute("class", TRACK_DECOR_1_CLASSES);
        barTable.setAttribute("cellpadding", MIN_VALUE_DEFAULT);
        barTable.setAttribute("cellspacing", MIN_VALUE_DEFAULT);
        nsIDOMElement barTR = visualDocument.createElement("tr");
        nsIDOMElement barTD = visualDocument.createElement("td");
        barTD.setAttribute("class", TRACK_DECOR_2_CLASSES);
        nsIDOMElement barImage = visualDocument.createElement("img");
        ComponentUtil.setImg(barImage, SPACER_IMAGE_PATH);
        barImage.setAttribute("style", SPACER_IMAGE_STYLE);
        barTD.appendChild((nsIDOMNode)barImage);
        barTR.appendChild((nsIDOMNode)barTD);
        barTable.appendChild((nsIDOMNode)barTR);
        barDiv.appendChild((nsIDOMNode)barTable);
        sliderTD.appendChild((nsIDOMNode)handlerWrapper);
        sliderTD.appendChild((nsIDOMNode)barDiv);
        sliderBlock.appendChild((nsIDOMNode)sliderTD);
        return sliderBlock;
    }

    private String getNumberValue(Element sourceElement, String attributeName, String defaultValue) {
        if (sourceElement.hasAttribute(attributeName)) {
            String stringValue = sourceElement.getAttribute(attributeName);
            try {
                Integer.decode(stringValue);
                return stringValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private boolean isShowInput(Element sourceElement) {
        if (sourceElement.hasAttribute(SHOW_INPUT_ATTR)) {
            String showInput = sourceElement.getAttribute(SHOW_INPUT_ATTR);
            return "true".equalsIgnoreCase(showInput);
        }
        return true;
    }

    private boolean isRightInputPosition(Element sourceElement) {
        return !sourceElement.hasAttribute(INPUT_POSITION_ATTR) || !"left".equalsIgnoreCase(sourceElement.getAttribute(INPUT_POSITION_ATTR));
    }

    private boolean isShowBoundaryValues(Element sourceElement) {
        return !sourceElement.hasAttribute(SHOW_BOUNDARY_VALUES) || !"false".equalsIgnoreCase(sourceElement.getAttribute(SHOW_BOUNDARY_VALUES));
    }
}

