/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.NewNameDialog;
import org.eclipse.jpt.common.ui.internal.widgets.NewNameDialogBuilder;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.ui.internal.details.GeneratorComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateGenericGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaDbGenericGenerator;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.GenericGeneratorComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

public class GenericGeneratorsComposite
extends Pane<HibernateGenericGeneratorContainer> {
    private AddRemoveListPane<HibernateGenericGeneratorContainer, JavaDbGenericGenerator> listPane;
    Pane<?> genericGeneratorPane;
    private NewNameDialogBuilder dialogBuilder = new NewNameDialogBuilder(this.getShell());
    private ModifiableCollectionValueModel<JavaDbGenericGenerator> selectedGeneratorsModel;
    private PropertyValueModel<JavaDbGenericGenerator> selectedGeneratorModel;

    public GenericGeneratorsComposite(Pane<?> parentPane, PropertyValueModel<? extends HibernateGenericGeneratorContainer> subjectHolder, Composite parent) {
        super(parentPane, parent);
        this.dialogBuilder.setDialogTitle(HibernateUIMappingMessages.GenericGeneratorsComposite_dialogTitle);
        this.dialogBuilder.setDescriptionTitle(HibernateUIMappingMessages.GenericGeneratorsComposite_DescriptionTitle);
        this.dialogBuilder.setDescription(HibernateUIMappingMessages.GenericGeneratorsComposite_Description);
        this.dialogBuilder.setLabelText(HibernateUIMappingMessages.GenericGeneratorsComposite_Name);
    }

    JavaDbGenericGenerator addGenericDbGenerator() {
        return this.addGenericGeneratorFromDialog(this.buildAddGenericGeneratorDialog());
    }

    protected HibernatePersistenceUnit getPersistenceUnit() {
        return (HibernatePersistenceUnit)((HibernateGenericGeneratorContainer)this.getSubject()).getPersistenceUnit();
    }

    protected NewNameDialog buildAddGenericGeneratorDialog() {
        this.dialogBuilder.setExistingNames(this.getPersistenceUnit().getUniqueGeneratorNames().iterator());
        return this.dialogBuilder.buildDialog();
    }

    protected JavaDbGenericGenerator addGenericGeneratorFromDialog(NewNameDialog dialog) {
        if (dialog.open() != 0) {
            return null;
        }
        JavaDbGenericGenerator generator = ((HibernateGenericGeneratorContainer)this.getSubject()).addGenericGenerator();
        generator.setName(dialog.getName());
        return generator;
    }

    private ListValueModel<GenericGenerator> buildDisplayableGenericGeneratorsListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGenericGeneratorsListHolder(), new String[]{"name"});
    }

    private AddRemoveListPane<HibernateGenericGeneratorContainer, JavaDbGenericGenerator> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildGenericGeneratorsAdapter(), this.buildDisplayableGenericGeneratorsListHolder(), this.selectedGeneratorsModel, this.buildGenericGeneratorsListLabelProvider());
    }

    private ListValueModel<GenericGenerator> buildGenericGeneratorsListHolder() {
        return new ListAspectAdapter<HibernateGeneratorContainer, GenericGenerator>(this.getSubjectHolder(), new String[]{"genericGenerators"}){

            protected ListIterator<GenericGenerator> listIterator_() {
                return ((HibernateGeneratorContainer)this.subject).getGenericGenerators().iterator();
            }

            protected int size_() {
                return ((HibernateGeneratorContainer)this.subject).getGenericGeneratorsSize();
            }
        };
    }

    private Transformer<GenericGenerator, Control> buildPaneTransformer() {
        return new Transformer<GenericGenerator, Control>(){

            public Control transform(GenericGenerator generator) {
                if (generator == null) {
                    return null;
                }
                return GenericGeneratorsComposite.this.genericGeneratorPane.getControl();
            }
        };
    }

    private AddRemovePane.Adapter<JavaDbGenericGenerator> buildGenericGeneratorsAdapter() {
        return new AddRemovePane.AbstractAdapter<JavaDbGenericGenerator>(){

            public JavaDbGenericGenerator addNewItem() {
                return GenericGeneratorsComposite.this.addGenericDbGenerator();
            }

            public void removeSelectedItems(CollectionValueModel<JavaDbGenericGenerator> selectedItemsModel) {
                Iterator iterator = selectedItemsModel.iterator();
                while (iterator.hasNext()) {
                    ((HibernateGenericGeneratorContainer)GenericGeneratorsComposite.this.getSubject()).removeGenericGenerator((GenericGenerator)iterator.next());
                }
            }
        };
    }

    private ILabelProvider buildGenericGeneratorsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                GenericGenerator generator = (GenericGenerator)element;
                String name = generator.getName();
                if (name == null) {
                    int index = IterableTools.indexOf((Iterable)((HibernateGenericGeneratorContainer)GenericGeneratorsComposite.this.getSubject()).getGenericGenerators(), (Object)generator);
                    name = NLS.bind((String)HibernateUIMappingMessages.GenericGeneratorsComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    protected void initialize() {
        super.initialize();
        this.selectedGeneratorsModel = this.buildSelectedGeneratorsModel();
        this.selectedGeneratorModel = this.buildSelectedGeneratorModel((CollectionValueModel<JavaDbGenericGenerator>)this.selectedGeneratorsModel);
    }

    private ModifiableCollectionValueModel<JavaDbGenericGenerator> buildSelectedGeneratorsModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<JavaDbGenericGenerator> buildSelectedGeneratorModel(CollectionValueModel<JavaDbGenericGenerator> selectedGeneratorsModel) {
        return new CollectionPropertyValueModelAdapter<JavaDbGenericGenerator, JavaDbGenericGenerator>(selectedGeneratorsModel){

            protected JavaDbGenericGenerator buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (JavaDbGenericGenerator)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.genericGeneratorPane = this.buildGenericGeneratorComposite(pageBook);
        this.installPaneSwitcher(pageBook);
    }

    protected Pane<? extends JavaDbGenericGenerator> buildGenericGeneratorComposite(PageBook pageBook) {
        return new GenericGeneratorComposite(this, this.selectedGeneratorModel, (Composite)pageBook, this.buildGenericGeneratorBuilder());
    }

    protected GeneratorComposite.GeneratorBuilder<JavaDbGenericGenerator> buildGenericGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<JavaDbGenericGenerator>(){

            public JavaDbGenericGenerator addGenerator() {
                HibernateGenericGeneratorContainer container = (HibernateGenericGeneratorContainer)GenericGeneratorsComposite.this.getSubject();
                JavaDbGenericGenerator generator = container.addGenericGenerator(container.getGenericGeneratorsSize());
                return generator;
            }
        };
    }

    private void installPaneSwitcher(PageBook pageBook) {
        SWTBindingTools.bind(this.getGenericGeneratorHolder(), this.buildPaneTransformer(), (PageBook)pageBook);
    }

    protected PropertyValueModel<JavaDbGenericGenerator> getGenericGeneratorHolder() {
        return this.selectedGeneratorModel;
    }
}

