/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.jee.AbstractClasspathContainer;
import org.jboss.ide.eclipse.as.classpath.core.jee.AbstractClasspathContainerInitializer;
import org.jboss.ide.eclipse.as.classpath.core.xpl.ClasspathDecorations;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.internal.BasePortletClasspathContainer;

public class PortletRuntimeLibrariesContainerInitializer
extends AbstractClasspathContainerInitializer {
    public String getDescription(IPath containerPath, IJavaProject project) {
        return Messages.PortletLibrariesContainerInitializer_JBoss_Portlet_Classpath_Container_Initializer;
    }

    protected AbstractClasspathContainer createClasspathContainer(IPath path) {
        return new PortletRuntimeClasspathContainer(path, this.javaProject);
    }

    protected String getClasspathContainerID() {
        return "org.jboss.tools.portlet.core.internal.portletlibrarycontainer.runtime";
    }

    public class PortletRuntimeClasspathContainer
    extends BasePortletClasspathContainer {
        private static final String LIB = "/lib";

        public PortletRuntimeClasspathContainer(IPath path, IJavaProject project) {
            super(project, path, Messages.PortletLibrariesContainerInitializer_JBoss_Portlet_Library, "portlet");
        }

        protected IClasspathEntry[] computeEntries() {
            IProject project;
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IJavaProject javaProject = this.getProject();
            if (javaProject != null && (project = javaProject.getProject()) != null) {
                try {
                    File[] jars;
                    File location;
                    File libDir;
                    IRuntime runtime = J2EEProjectUtilities.getServerRuntime((IProject)project);
                    if (runtime != null && (libDir = this.getLibDirectory(location = runtime.getLocation().toFile())) != null && (jars = libDir.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            String name = file.getName();
                            return name.startsWith("portlet-api") && name.endsWith(".jar");
                        }
                    })) != null) {
                        int i = 0;
                        while (i < jars.length) {
                            File jarFile = jars[i];
                            Path entryPath = new Path(jarFile.toString());
                            IPath sourceAttachementPath = null;
                            IPath sourceAttachementRootPath = null;
                            ClasspathDecorations dec = decorations.getDecorations(PortletRuntimeClasspathContainer.getDecorationManagerKey((String)this.getPath().toString()), entryPath.toString());
                            IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
                            if (dec != null) {
                                sourceAttachementPath = dec.getSourceAttachmentPath();
                                sourceAttachementRootPath = dec.getSourceAttachmentRootPath();
                                attrs = dec.getExtraAttributes();
                            }
                            IAccessRule[] access = new IAccessRule[]{};
                            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourceAttachementPath, (IPath)sourceAttachementRootPath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
                            entries.add(entry);
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    PortletCoreActivator.log(e);
                }
            }
            return entries.toArray(new IClasspathEntry[entries.size()]);
        }

        private File getLibDirectory(File location) {
            IJavaProject javaProject = this.getProject();
            if (javaProject == null) {
                return null;
            }
            IProject project = javaProject.getProject();
            if (project == null) {
                return null;
            }
            IRuntime runtime = null;
            try {
                runtime = J2EEProjectUtilities.getServerRuntime((IProject)project);
            }
            catch (CoreException coreException) {}
            if (runtime == null) {
                return null;
            }
            IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (jbossRuntime == null) {
                return null;
            }
            String[] directories = new String[]{"deploy/jboss-portal.sar/lib", "deploy/simple-portal", "deploy/simple-portal.sar/lib", "deploy/jboss-portal-ha.sar/lib", "deploy/gatein.ear/lib"};
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            location = configPath.toFile();
            String[] stringArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                File libDirectory = this.getDirectory(location, dir);
                if (libDirectory != null) {
                    return libDirectory;
                }
                ++n2;
            }
            String[] directories2 = new String[]{"gatein/modules/javax/portlet/api/main", "modules/javax/portlet/api/main", "modules/system/layers/base/javax/portlet/api/main", "modules/system/add-ons/gatein/javax/portlet/api/main/", "modules/system/layers/gatein/javax/portlet/api/main/"};
            File file = jbossLocation.toFile();
            String[] stringArray2 = directories2;
            int n3 = directories2.length;
            int n4 = 0;
            while (n4 < n3) {
                String dir = stringArray2[n4];
                File libDirectory = this.getDirectory(file, dir);
                if (libDirectory != null) {
                    return libDirectory;
                }
                ++n4;
            }
            return null;
        }

        private File getDirectory(File location, String portalDir) {
            File file;
            if (Platform.getOS().equals("win32")) {
                portalDir = portalDir.replace("/", "\\");
            }
            if ((file = new File(location, portalDir)).exists() && file.isDirectory()) {
                return file;
            }
            return null;
        }

        public void refresh() {
            new PortletRuntimeClasspathContainer(this.path, this.javaProject).install();
        }
    }
}

