/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.PortletCoreActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRuntimeComponentProvider
extends RuntimeFacetComponentProviderDelegate {
    public static final String IS_PORTLET_RUNTIME = "isPortletRuntime";
    private static final IRuntimeComponentType PORTAL_TYPE = RuntimeManager.getRuntimeComponentType((String)"org.jboss.tools.portlet.core.runtime.component");
    private static final IRuntimeComponentVersion PORTAL_VERSION_1 = PORTAL_TYPE.getVersion("1.0");

    public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        File location;
        ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>();
        if (runtime != null && runtime.getLocation() != null && PortletRuntimeComponentProvider.isPortalPresentInternal(location = runtime.getLocation().toFile(), runtime)) {
            IRuntimeComponent portalComponent = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)PORTAL_VERSION_1, null);
            components.add(portalComponent);
        }
        return components;
    }

    private static boolean isPortalPresentInternal(File location, IRuntime runtime) {
        boolean check = PortletCoreActivator.getDefault().getPluginPreferences().getBoolean("checkRuntimes");
        if (!check) {
            return true;
        }
        return PortletRuntimeComponentProvider.isPortalPresent(location, runtime, IS_PORTLET_RUNTIME);
    }

    public static boolean isPortalPresent(File location, IRuntime runtime, String property) {
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            File configFile = configPath.toFile();
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/jboss-portal.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/jboss-portal-ha.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/simple-portal") || PortletRuntimeComponentProvider.exists(configFile, "deploy/simple-portal.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/gatein.ear")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(jbossLocation.toFile(), "standalone/deployments/gatein.ear")) {
                return true;
            }
            return PortletRuntimeComponentProvider.exists(jbossLocation.toFile(), "gatein/gatein.ear");
        }
        if (!IS_PORTLET_RUNTIME.equals(property)) {
            return false;
        }
        File tomcatLib = new File(location, "lib");
        if (tomcatLib.exists() && tomcatLib.isDirectory()) {
            String[] files = tomcatLib.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("portlet-api") && name.endsWith(".jar");
                }
            });
            return files.length > 0;
        }
        return false;
    }

    private static boolean exists(File location, String portalDir) {
        if (Platform.getOS().equals("win32")) {
            portalDir = portalDir.replace("/", "\\");
        }
        File file = new File(location, portalDir);
        return file.exists();
    }
}

