/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.launcher;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;

public class JaxrsEndpointModuleArtifact
extends ModuleArtifactDelegate {
    private IModule module;
    private IJaxrsEndpoint endpoint;
    private String endpointURI;
    private String httpVerb;

    public JaxrsEndpointModuleArtifact() {
    }

    public JaxrsEndpointModuleArtifact(IModule module, IJaxrsEndpoint endpoint) {
        this.module = module;
        this.endpoint = endpoint;
    }

    public IModule getModule() {
        return this.module;
    }

    @Deprecated
    public IJaxrsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointURI() {
        if (this.endpointURI == null && this.endpoint != null) {
            this.endpointURI = this.computeEndpointURI(this.module, this.endpoint);
        }
        return this.endpointURI;
    }

    public String getHttpVerb() {
        if (this.endpoint != null) {
            return this.endpoint.getHttpMethod().getHttpVerb();
        }
        return this.httpVerb;
    }

    private String computeEndpointURI(IModule module, IJaxrsEndpoint endpoint) {
        String uriPathTemplate = endpoint.getUriPathTemplate();
        if (!uriPathTemplate.startsWith("/")) {
            uriPathTemplate = "/" + uriPathTemplate;
        }
        String fullUriPathTemplate = String.valueOf(module.getName()) + uriPathTemplate;
        IServer[] servers = ServerUtil.getServersByModule((IModule)module, null);
        if (servers == null || servers.length == 0) {
            return "http://[domain]:[port]/" + fullUriPathTemplate;
        }
        String domain = servers[0].getHost();
        String webport = servers[0].getAttribute("org.jboss.ide.eclipse.as.core.server.webPort", "8080");
        return "http://" + domain + ':' + webport + "/" + fullUriPathTemplate;
    }

    public String getName() {
        return this.getEndpointURI();
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.module.getId());
        sb.append("\n");
        sb.append(this.getEndpointURI());
        sb.append("\n");
        sb.append(this.getHttpVerb());
        return sb.toString();
    }

    public void deserialize(String s) {
        String[] byLine = s.split("\n");
        if (byLine != null) {
            if (byLine.length > 0 && byLine[0] != null) {
                this.module = ServerUtil.getModule((String)byLine[0]);
            }
            if (byLine.length > 1 && byLine[1] != null) {
                this.endpointURI = byLine[1];
            }
            if (byLine.length > 2 && byLine[2] != null) {
                this.httpVerb = byLine[2];
            }
        }
    }
}

