/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.server.ServerUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.util.DeployFolder;
import org.osgi.service.prefs.BackingStoreException;

public class ExpressServerUtils {
    public static final String NODE_QUALIFIER = "org.jboss.tools.openshift.express.ui";
    public static final String ATTRIBUTE_DEPLOY_PROJECT = "org.jboss.tools.openshift.binary.deployProject";
    public static final String ATTRIBUTE_OVERRIDE_PROJECT_SETTINGS = "org.jboss.tools.openshift.project.override";
    public static final String ATTRIBUTE_DEPLOY_PROJECT_LEGACY = "org.jboss.tools.openshift.express.internal.core.server.binary.deployProject";
    public static final String ATTRIBUTE_REMOTE_NAME = "org.jboss.tools.openshift.express.internal.core.server.RemoteName";
    public static final String ATTRIBUTE_APPLICATION_NAME = "org.jboss.tools.openshift.express.internal.core.server.ApplicationName";
    public static final String ATTRIBUTE_APPLICATION_ID = "org.jboss.tools.openshift.express.internal.core.server.ApplicationId";
    public static final String ATTRIBUTE_DOMAIN = "org.jboss.tools.openshift.express.internal.core.server.Domain";
    public static final String ATTRIBUTE_USERNAME = "org.jboss.tools.openshift.express.internal.core.server.Username";
    public static final String ATTRIBUTE_DEPLOY_FOLDER_NAME = "org.jboss.tools.openshift.express.internal.core.server.DEPLOY_FOLDER_LOC";
    public static final String SETTING_REMOTE_NAME = "org.jboss.tools.openshift.RemoteName";
    public static final String SETTING_APPLICATION_NAME = "org.jboss.tools.openshift.ApplicationName";
    public static final String SETTING_APPLICATION_ID = "org.jboss.tools.openshift.ApplicationId";
    public static final String SETTING_DOMAIN_ID = "org.jboss.tools.openshift.Domain";
    public static final String SETTING_USERNAME = "org.jboss.tools.openshift.Username";
    public static final String SETTING_CONNECTIONURL = "org.jboss.tools.openshift.Connection";
    public static final String SETTING_DEPLOY_FOLDER_NAME = "org.jboss.tools.openshift.DeployFolder";
    public static final String ATTRIBUTE_REMOTE_NAME_DEFAULT = "origin";
    private static final String ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT = "deployments";
    public static final String PREFERENCE_IGNORE_CONTEXT_ROOT = "org.jboss.tools.openshift.express.internal.core.server.IgnoreContextRoot";
    public static final String EXPRESS_SERVER_TYPE = "org.jboss.tools.openshift.express.openshift.server.type";
    public static final String AT_OPENSHIFT_2 = " at OpenShift 2";
    public static int SETTING_FROM_PROJECT = 1;
    public static int SETTING_FROM_SERVER = 2;
    public static int SETTING_EFFECTIVE_VALUE = 3;

    public static String getProjectAttribute(String name, String defaultValue, IProject project) {
        return ServerUtils.getProjectAttribute((String)name, (String)defaultValue, (String)NODE_QUALIFIER, (IProject)project);
    }

    public static String getProjectAttribute(String name, String defaultValue, IServerAttributes attributes) {
        return ExpressServerUtils.getProjectAttribute(name, defaultValue, ExpressServerUtils.getDeployProject(attributes));
    }

    public static String getDeployProjectName(IServerAttributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getAttribute(ATTRIBUTE_DEPLOY_PROJECT, null);
    }

    public static IProject getDeployProject(IServerAttributes attributes) {
        return ProjectUtils.getProject((String)ExpressServerUtils.getDeployProjectName(attributes));
    }

    public static IApplication getApplication(IServerAttributes server) {
        ExpressConnection connection;
        String appName;
        block5: {
            appName = ExpressServerUtils.getApplicationName(server);
            if (StringUtils.isEmpty((String)appName)) {
                return null;
            }
            ConnectionURL connectionUrl = ExpressServerUtils.getConnectionUrl(server);
            if (connectionUrl == null) {
                return null;
            }
            try {
                connection = (ExpressConnection)ConnectionsRegistrySingleton.getInstance().getByUrl(connectionUrl, ExpressConnection.class);
                if (connection != null) break block5;
                ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not find connection {0}", (Object)connectionUrl.toString()));
                return null;
            }
            catch (OpenShiftException e) {
                ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Failed to retrieve application ''{0}'' at url ''{1}}'", (Object)appName, (Object)connectionUrl), (Throwable)e);
                return null;
            }
        }
        IDomain domain = connection.getDomain(ExpressServerUtils.getDomainName(server));
        return connection.getApplication(appName, domain);
    }

    public static String getApplicationName(IServerAttributes attributes) {
        return ExpressServerUtils.getProjectAttribute(SETTING_APPLICATION_NAME, attributes.getAttribute(ATTRIBUTE_APPLICATION_NAME, null), ExpressServerUtils.getDeployProject(attributes));
    }

    public static String getApplicationId(IServerAttributes attributes) {
        return ExpressServerUtils.getProjectAttribute(SETTING_APPLICATION_ID, attributes.getAttribute(ATTRIBUTE_APPLICATION_ID, null), ExpressServerUtils.getDeployProject(attributes));
    }

    public static String getDomainName(IServerAttributes attributes) {
        return ExpressServerUtils.getProjectAttribute(SETTING_DOMAIN_ID, attributes.getAttribute(ATTRIBUTE_DOMAIN, null), ExpressServerUtils.getDeployProject(attributes));
    }

    private static String getUsername(IServerAttributes attributes) {
        return ExpressServerUtils.getProjectAttribute(SETTING_USERNAME, attributes.getAttribute(ATTRIBUTE_USERNAME, null), ExpressServerUtils.getDeployProject(attributes));
    }

    public static ConnectionURL getConnectionUrl(IServerAttributes attributes) {
        try {
            String connectionUrlString = ExpressServerUtils.getProjectAttribute(SETTING_CONNECTIONURL, null, ExpressServerUtils.getDeployProject(attributes));
            if (!StringUtils.isEmpty((String)connectionUrlString)) {
                return ConnectionURL.forURL((String)connectionUrlString);
            }
            String username = ExpressServerUtils.getUsername(attributes);
            if (!StringUtils.isEmpty((String)username)) {
                return ConnectionURL.forUsername((String)username);
            }
        }
        catch (UnsupportedEncodingException e) {
            ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for user {0}", (Object)attributes.getName()), (Throwable)e);
        }
        catch (MalformedURLException e) {
            ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for user {0}", (Object)attributes.getName()), (Throwable)e);
        }
        return null;
    }

    public static String getDeployFolder(IServerAttributes attributes) {
        return ExpressServerUtils.getDeployFolder(attributes, ExpressServerUtils.getApplication(attributes));
    }

    public static String getDeployFolder(IServerAttributes attributes, IApplication application) {
        return ExpressServerUtils.getDeployFolder(attributes, ExpressServerUtils.getDefaultDeployFolder(application));
    }

    private static String getDeployFolder(IServerAttributes attributes, String defaultDeployFolder) {
        if (ExpressServerUtils.isOverridesProject(attributes)) {
            return attributes.getAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, defaultDeployFolder);
        }
        return ExpressServerUtils.getProjectAttribute(SETTING_DEPLOY_FOLDER_NAME, defaultDeployFolder, ExpressServerUtils.getDeployProject(attributes));
    }

    public static String getDefaultDeployFolder(IServerAttributes server) {
        return ExpressServerUtils.getDefaultDeployFolder(ExpressServerUtils.getApplication(server));
    }

    public static String getDefaultDeployFolder(IApplication application) {
        Assert.isNotNull((Object)application);
        DeployFolder deployFolder = DeployFolder.getByCartridgeName(application.getCartridge().getName());
        if (deployFolder == null) {
            return null;
        }
        return deployFolder.getDeployFolder();
    }

    public static String getRemoteName(IServerAttributes attributes) {
        if (ExpressServerUtils.isOverridesProject(attributes)) {
            return attributes.getAttribute(ATTRIBUTE_REMOTE_NAME, ATTRIBUTE_REMOTE_NAME_DEFAULT);
        }
        return ExpressServerUtils.getProjectAttribute(SETTING_REMOTE_NAME, ATTRIBUTE_REMOTE_NAME_DEFAULT, ExpressServerUtils.getDeployProject(attributes));
    }

    public static String getDeployFolder(IServerAttributes attributes, int fromWhere) {
        String fromServer = attributes.getAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, null);
        if (fromWhere == SETTING_FROM_SERVER) {
            return fromServer;
        }
        String fromProject = ExpressServerUtils.getProjectAttribute(SETTING_DEPLOY_FOLDER_NAME, null, ExpressServerUtils.getDeployProject(attributes));
        if (fromWhere == SETTING_FROM_PROJECT) {
            return fromProject;
        }
        if (ExpressServerUtils.isOverridesProject(attributes)) {
            return fromServer == null ? ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT : fromServer;
        }
        return fromProject == null ? ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT : fromProject;
    }

    public static String getRemoteName(IServerAttributes attributes, int fromWhere) {
        String fromServer = attributes.getAttribute(ATTRIBUTE_REMOTE_NAME, null);
        if (fromWhere == SETTING_FROM_SERVER) {
            return fromServer;
        }
        String fromProject = ExpressServerUtils.getProjectAttribute(SETTING_REMOTE_NAME, null, ExpressServerUtils.getDeployProject(attributes));
        if (fromWhere == SETTING_FROM_PROJECT) {
            return fromProject;
        }
        if (ExpressServerUtils.isOverridesProject(attributes)) {
            return fromServer == null ? ATTRIBUTE_REMOTE_NAME_DEFAULT : fromServer;
        }
        return fromProject == null ? ATTRIBUTE_REMOTE_NAME_DEFAULT : fromProject;
    }

    public static boolean getIgnoresContextRoot(IServerAttributes server) {
        return server.getAttribute(PREFERENCE_IGNORE_CONTEXT_ROOT, true);
    }

    public static boolean isOverridesProject(IServerAttributes server) {
        return server.getAttribute(ATTRIBUTE_OVERRIDE_PROJECT_SETTINGS, false);
    }

    public static IServer setIgnoresContextRoot(IServerAttributes server, boolean val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer fillServerWithOpenShiftDetails(IServer server, String deployProject, String remote, String serverName, IApplication application, IDomain domain) throws CoreException {
        ServerWorkingCopy wc = (ServerWorkingCopy)server.createWorkingCopy();
        String deployFolder = ExpressServerUtils.getDefaultDeployFolder(application);
        String host = ExpressServerUtils.getHost(application);
        String applicationName = ExpressServerUtils.getApplicationName(application);
        String domainId = ExpressServerUtils.getDomainId(domain);
        ExpressServerUtils.fillServerWithOpenShiftDetails((IServerWorkingCopy)wc, serverName, host, deployProject, deployFolder, remote, applicationName, domainId);
        IServer saved = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        return saved;
    }

    public static void fillServerWithOpenShiftDetails(IServerWorkingCopy wc, String serverName, IProject deployProject, String deployFolder, String remote, IApplication application, IDomain domain) {
        String host = ExpressServerUtils.getHost(application);
        String deployProjectName = ProjectUtils.getName((IProject)deployProject);
        String applicationName = ExpressServerUtils.getApplicationName(application);
        String domainId = ExpressServerUtils.getDomainId(domain);
        ExpressServerUtils.fillServerWithOpenShiftDetails(wc, serverName, host, deployProjectName, deployFolder, remote, applicationName, domainId);
    }

    private static String getHost(IApplication application) {
        String host = null;
        if (application != null) {
            host = application.getApplicationUrl();
        }
        return host;
    }

    private static String getApplicationName(IApplication application) {
        String name = null;
        if (application != null) {
            name = application.getName();
        }
        return name;
    }

    private static String getDomainId(IDomain domain) {
        String id = null;
        if (domain != null) {
            id = domain.getId();
        }
        return id;
    }

    public static void fillServerWithOpenShiftDetails(IServerWorkingCopy wc, String serverName, String host, String deployProject, String deployFolder, String remote, String applicationName, String domainName) {
        wc.setHost(UrlUtils.getHost((String)host));
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift");
        wc.setAttribute(ATTRIBUTE_DEPLOY_PROJECT, deployProject);
        wc.setAttribute(ATTRIBUTE_DOMAIN, domainName);
        wc.setAttribute(ATTRIBUTE_APPLICATION_NAME, applicationName);
        wc.setAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, deployFolder);
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, remote);
        ((ServerWorkingCopy)wc).setAutoPublishSetting(1);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", String.valueOf(Boolean.TRUE));
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.webPort", 80);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "false");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", true);
        wc.setName(serverName);
    }

    public static String getDefaultServerName(IApplication application) {
        if (application == null) {
            return null;
        }
        return ServerUtils.getServerName((String)(String.valueOf(application.getName()) + AT_OPENSHIFT_2));
    }

    public static IServer createServer(String serverID) throws CoreException {
        return ExpressServerUtils.createServer(ServerCore.findServerType((String)serverID), serverID);
    }

    public static IServer createServer(IServerType serverType, String serverName) throws CoreException {
        IServerWorkingCopy serverWC = serverType.createServer(null, null, (IProgressMonitor)new NullProgressMonitor());
        serverWC.setRuntime(null);
        serverWC.setName(serverName);
        serverWC.setServerConfiguration(null);
        serverWC.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift");
        return serverWC.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isExpressRuntime(IServerAttributes server) {
        String serverTypeId = server.getServerType().getId();
        return EXPRESS_SERVER_TYPE.equals(serverTypeId);
    }

    public static boolean isInOpenshiftBehaviourMode(IServer server) {
        String mode = server.getAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", null);
        return "openshift".equals(mode);
    }

    public static IApplication getApplicationForProject(IProject project, List<IApplication> applications) throws OpenShiftException, CoreException {
        List uris = EGitUtils.getDefaultRemoteURIs((IProject)project);
        for (IApplication a : applications) {
            String gitUri = a.getGitUrl();
            Iterator j = uris.iterator();
            while (j.hasNext()) {
                String projUri = ((URIish)j.next()).toPrivateString();
                if (!projUri.equals(gitUri)) continue;
                return a;
            }
        }
        return null;
    }

    public static IProject[] getProjectsForApplication(IApplication application) {
        if (application == null) {
            return null;
        }
        ArrayList<IProject> results = new ArrayList<IProject>();
        String gitUri = application.getGitUrl();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (ExpressServerUtils.hasRemoteGitUri(gitUri, projects[i])) {
                results.add(projects[i]);
            }
            ++i;
        }
        return results.toArray(new IProject[results.size()]);
    }

    private static boolean hasRemoteGitUri(String gitURI, IProject project) {
        String remote = ExpressServerUtils.getProjectAttribute(SETTING_REMOTE_NAME, null, project);
        try {
            return EGitUtils.hasGitUri((String)gitURI, (String)remote, (IProject)project);
        }
        catch (CoreException e) {
            ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not look up remotes for project {0}", (Object)project.getName()), (Throwable)e);
            return false;
        }
    }

    public static IProject[] getAllOpenshiftProjects() {
        ArrayList<IProject> results = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (EGitUtils.getRepository((IProject)projects[i]) != null && ExpressServerUtils.hasOpenShiftSettings(projects[i])) {
                results.add(projects[i]);
            }
            ++i;
        }
        return results.toArray(new IProject[results.size()]);
    }

    private static boolean hasOpenShiftSettings(IProject project) {
        String appName = ExpressServerUtils.getProjectAttribute(SETTING_APPLICATION_NAME, null, project);
        String appId = ExpressServerUtils.getProjectAttribute(SETTING_APPLICATION_ID, null, project);
        String domain = ExpressServerUtils.getProjectAttribute(SETTING_DOMAIN_ID, null, project);
        String connectionUrl = ExpressServerUtils.getProjectAttribute(SETTING_CONNECTIONURL, null, project);
        String username = ExpressServerUtils.getProjectAttribute(SETTING_USERNAME, null, project);
        return appName != null && appId != null && domain != null && (connectionUrl != null || username != null);
    }

    public static IProject findProjectForApplication(IApplication application) {
        IProject[] p = ExpressServerUtils.getProjectsForApplication(application);
        return p == null ? null : (p.length == 0 ? null : p[0]);
    }

    public static void updateOpenshiftProjectSettings(IProject project, IApplication app, IDomain domain, ExpressConnection connection, String remoteName, String deployFolder) {
        String qualifier = NODE_QUALIFIER;
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        node.put(SETTING_APPLICATION_ID, app.getUUID());
        node.put(SETTING_APPLICATION_NAME, app.getName());
        node.put(SETTING_DOMAIN_ID, app.getDomain().getId());
        ExpressServerUtils.setConnectionUrl((IConnection)connection, node);
        node.put(SETTING_REMOTE_NAME, remoteName);
        if (!StringUtils.isEmpty((String)deployFolder)) {
            node.put(SETTING_DEPLOY_FOLDER_NAME, deployFolder);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ExpressCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    private static void setConnectionUrl(IConnection connection, IEclipsePreferences node) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection((IConnection)connection);
            node.put(SETTING_CONNECTIONURL, connectionUrl.toString());
            if (ExpressServerUtils.hasUsername(node)) {
                node.put(SETTING_USERNAME, connection.getUsername());
            }
        }
        catch (UnsupportedEncodingException e) {
            ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for connection {0}/{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
        catch (MalformedURLException e) {
            ExpressCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for connection {0}/{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
    }

    private static boolean hasUsername(IEclipsePreferences node) {
        return node.get(SETTING_USERNAME, null) != null;
    }

    public static IServer setDeployProject(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_DEPLOY_PROJECT, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer setRemoteName(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressApplication(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_APPLICATION_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressDomain(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_DOMAIN, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressUsername(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_USERNAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static String[] toNames(List<IApplication> apps) {
        if (apps == null) {
            return new String[0];
        }
        String[] appNames = new String[apps.size()];
        int i = 0;
        while (i < apps.size()) {
            appNames[i] = apps.get(i).getName();
            ++i;
        }
        return appNames;
    }
}

