/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.server.ExpressServerUtils;

public class ExpressServerFactory {
    public IServer create(IProject project, IApplication application, IDomain domain, IProgressMonitor monitor) throws OpenShiftException {
        return this.createAdapterAndModules(project, application, domain, null, monitor);
    }

    protected IServer createAdapterAndModules(IProject project, IApplication application, IDomain domain, String remoteName, IProgressMonitor monitor) throws OpenShiftException {
        monitor.subTask(NLS.bind((String)"Creating server adapter for project {0}", (Object)project.getName()));
        IServer server = null;
        try {
            IServerType serverType = ServerCore.findServerType((String)"org.jboss.tools.openshift.express.openshift.server.type");
            server = this.createAdapter(serverType, application, domain, project.getName(), remoteName);
            server = this.addModules(this.getModules(Collections.singletonList(project)), server, monitor);
        }
        catch (CoreException ce) {
            ExpressCoreActivator.getDefault().getLog().log(ce.getStatus());
        }
        catch (OpenShiftException ose) {
            Status s = new Status(4, "org.jboss.tools.openshift.express.core", "Cannot create openshift server adapter", (Throwable)ose);
            ExpressCoreActivator.getDefault().getLog().log((IStatus)s);
        }
        return server;
    }

    private IServer createAdapter(IServerType serverType, IApplication application, IDomain domain, String deployProject, String remoteName) throws CoreException, OpenShiftException {
        Assert.isLegal((serverType != null ? 1 : 0) != 0, (String)"Missing server adapter type");
        Assert.isLegal((application != null ? 1 : 0) != 0, (String)"Missing application");
        String serverName = ExpressServerUtils.getDefaultServerName(application);
        IServer server = ExpressServerUtils.createServer(serverType, serverName);
        ExpressServerUtils.fillServerWithOpenShiftDetails(server, deployProject, remoteName, serverName, application, domain);
        return server;
    }

    public void addModules(IServer server, List<IProject> importedProjects, IProgressMonitor monitor) throws CoreException {
        this.addModules(this.getModules(importedProjects), server, monitor);
    }

    private IServer addModules(List<IModule> modules, IServer server, IProgressMonitor monitor) throws CoreException {
        if (modules == null || modules.size() == 0) {
            return server;
        }
        IServerWorkingCopy wc = server.createWorkingCopy();
        IModule[] addedModules = modules.toArray(new IModule[modules.size()]);
        wc.modifyModules(addedModules, new IModule[0], monitor);
        server = wc.save(true, monitor);
        ((Server)server).setModulePublishState(addedModules, 1);
        return server;
    }

    private List<IModule> getModules(List<IProject> importedProjects) {
        Iterator<IProject> i = importedProjects.iterator();
        ArrayList<IModule> toAdd = new ArrayList<IModule>();
        while (i.hasNext()) {
            IProject p = i.next();
            IModule[] m = ServerUtil.getModules((IProject)p);
            if (m == null || m.length <= 0) continue;
            toAdd.addAll(Arrays.asList(m));
        }
        return toAdd;
    }
}

