/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import org.apache.commons.lang.ArrayUtils;
import org.jboss.tools.openshift.common.core.connection.AbstractConnectionPersistency;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.express.core.ExpressCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.LazyCredentialsPrompter;
import org.jboss.tools.openshift.express.internal.core.LazySSLCertificateCallback;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.preferences.ExpressCorePreferences;

public class ExpressConnectionPersistency
extends AbstractConnectionPersistency<ExpressConnection> {
    protected String[] loadPersisted() {
        return (String[])ArrayUtils.addAll((Object[])ExpressCorePreferences.INSTANCE.loadConnections(), (Object[])ExpressCorePreferences.INSTANCE.loadLegacyConnections());
    }

    protected void persist(String[] connections) {
        ExpressCorePreferences.INSTANCE.saveConnections(connections);
    }

    protected void logError(String message, Exception e) {
        ExpressCoreActivator.pluginLog().logError(message, (Throwable)e);
    }

    protected ExpressConnection createConnection(ConnectionURL connectionURL) {
        return new ExpressConnection(connectionURL.getUsername(), connectionURL.getHostWithScheme(), new LazyCredentialsPrompter(ExpressCoreUIIntegration.getDefault().getCredentialPrompter()), new LazySSLCertificateCallback(ExpressCoreUIIntegration.getDefault().getSSLCertificateCallback()));
    }
}

