/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.xml;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.cdi.xml.CDIXMLPlugin;

public class CDIXMLImages {
    private static CDIXMLImages INSTANCE;
    public static final ImageDescriptor BEAN_CLASS_IMAGE;
    public static final ImageDescriptor ANNOTATION_IMAGE;
    public static final ImageDescriptor BEANS_XML_IMAGE;
    private URL baseUrl;

    static {
        try {
            INSTANCE = new CDIXMLImages(new URL(CDIXMLPlugin.getDefault().getBundle().getEntry("/"), "images/"));
        }
        catch (MalformedURLException e) {
            CDIXMLPlugin.getDefault().logError(e);
        }
        BEAN_CLASS_IMAGE = CDIXMLImages.getImageDescriptor("bean_class.png");
        ANNOTATION_IMAGE = CDIXMLImages.getImageDescriptor("annotation.png");
        BEANS_XML_IMAGE = CDIXMLImages.getImageDescriptor("beans_xml.png");
    }

    public static Image getImage(String key) {
        return INSTANCE.createImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return INSTANCE.createImageDescriptor(key);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(INSTANCE.createImageDescriptor(iconName));
    }

    public static CDIXMLImages getInstance() {
        return INSTANCE;
    }

    protected CDIXMLImages(URL registryUrl) {
        this.baseUrl = registryUrl;
    }

    public Image getImageByFileName(String key) {
        return this.createImageDescriptor(key).createImage();
    }

    public ImageDescriptor createImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(key));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private URL makeIconFileURL(String name) throws MalformedURLException {
        return new URL(this.baseUrl, name);
    }
}

