/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsHttpMethod
extends JaxrsJavaElement<IType>
implements IJaxrsHttpMethod {
    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsHttpMethod(Builder builder) {
        this(builder.javaType, (Map<String, Annotation>)builder.annotations, builder.metamodel, (JaxrsHttpMethod)null);
    }

    protected JaxrsHttpMethod(IType javaType, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, JaxrsHttpMethod primaryCopy) {
        super(javaType, annotations, metamodel, primaryCopy);
    }

    @Override
    public boolean isBuiltIn() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsHttpMethod createWorkingCopy() {
        JaxrsHttpMethod jaxrsHttpMethod = this;
        synchronized (jaxrsHttpMethod) {
            return new JaxrsHttpMethod((IType)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this);
        }
    }

    @Override
    public JaxrsHttpMethod getWorkingCopy() {
        return (JaxrsHttpMethod)super.getWorkingCopy();
    }

    @Override
    public String getJavaClassName() {
        if (this.getJavaElement() != null) {
            return ((IType)this.getJavaElement()).getFullyQualifiedName();
        }
        return null;
    }

    @Override
    boolean isMarkedForRemoval() {
        return this.getHttpMethodAnnotation() == null;
    }

    @Override
    public String getHttpVerb() {
        Annotation httpVerbAnnotation = this.getHttpMethodAnnotation();
        if (httpVerbAnnotation != null) {
            return httpVerbAnnotation.getValue();
        }
        return null;
    }

    public Annotation getHttpMethodAnnotation() {
        return this.getAnnotation("javax.ws.rs.HttpMethod");
    }

    public Annotation getRetentionAnnotation() {
        return this.getAnnotation(Retention.class.getName());
    }

    public Annotation getTargetAnnotation() {
        return this.getAnnotation(Target.class.getName());
    }

    @Override
    public final int compareTo(IJaxrsHttpMethod other) {
        if (this.getHttpVerb() == null) {
            return 1;
        }
        HttpVerbSortEnum enum1 = HttpVerbSortEnum.from(this.getHttpVerb());
        HttpVerbSortEnum enum2 = HttpVerbSortEnum.from(other.getHttpVerb());
        if (enum1.getRank() != enum2.getRank()) {
            return enum1.getRank() - enum2.getRank();
        }
        return this.getHttpVerb().toUpperCase().compareTo(other.getHttpVerb().toUpperCase());
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.HTTP_METHOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IJavaElement element, CompilationUnit ast) throws CoreException {
        JaxrsHttpMethod jaxrsHttpMethod = this;
        synchronized (jaxrsHttpMethod) {
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            JaxrsHttpMethod transientHttpMethod = JaxrsHttpMethod.from(element, ast).build(false);
            if (transientHttpMethod == null) {
                this.remove(annotationsFlags);
            } else {
                Flags updateAnnotationsFlags = this.updateAnnotations(transientHttpMethod.getAnnotations());
                if (this.isMarkedForRemoval()) {
                    this.remove(annotationsFlags);
                } else if (this.hasMetamodel()) {
                    JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    /* synthetic */ JaxrsHttpMethod(Builder builder, JaxrsHttpMethod jaxrsHttpMethod) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private JaxrsMetamodel metamodel = null;
        private Map<String, Annotation> annotations;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsHttpMethod build() throws CoreException {
            return this.build(true);
        }

        JaxrsHttpMethod build(boolean joinMetamodel) throws CoreException {
            long start;
            block6: {
                block5: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block5;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS HTTP Method in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS HTTP Method in {}ms", end - start);
                    return null;
                }
                JdtUtils.makeConsistentIfNecessary((IMember)this.javaType);
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                if (this.annotations != null && !this.annotations.isEmpty() && this.annotations.containsKey("javax.ws.rs.HttpMethod")) break block6;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS HTTP Method in {}ms", end - start);
                return null;
            }
            JaxrsHttpMethod httpMethod = new JaxrsHttpMethod(this, null);
            if (joinMetamodel) {
                httpMethod.joinMetamodel();
            }
            JaxrsHttpMethod jaxrsHttpMethod = httpMethod;
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS HTTP Method in {}ms", end - start);
            return jaxrsHttpMethod;
        }
    }

    private static enum HttpVerbSortEnum {
        GET(0),
        POST(1),
        PUT(2),
        DELETE(3),
        HEAD(5),
        OPTIONS(6),
        OTHER(7);

        private int rank = 0;

        private HttpVerbSortEnum(int r) {
            this.rank = r;
        }

        int getRank() {
            return this.rank;
        }

        static HttpVerbSortEnum from(String verb) {
            HttpVerbSortEnum[] httpVerbSortEnumArray = HttpVerbSortEnum.values();
            int n = httpVerbSortEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                HttpVerbSortEnum e = httpVerbSortEnumArray[n2];
                if (verb.equals(e.toString())) {
                    return e;
                }
                ++n2;
            }
            return OTHER;
        }
    }
}

