/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsElementsComparator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamConverterProvider;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;

public class JaxrsElementFactory {
    public static List<IJaxrsElement> createElements(IJavaElement element, CompilationUnit ast, JaxrsMetamodel metamodel, IProgressMonitor progressMonitor) throws CoreException {
        ArrayList<IJaxrsElement> elements = new ArrayList<IJaxrsElement>();
        switch (element.getElementType()) {
            case 9: {
                elements.addAll(JaxrsElementFactory.createElements((IMethod)element, ast, metamodel, progressMonitor));
                break;
            }
            case 8: {
                elements.addAll(JaxrsElementFactory.createElements((IField)element, ast, metamodel, progressMonitor));
                break;
            }
            case 16: {
                elements.addAll(JaxrsElementFactory.createElements((IAnnotation)element, ast, metamodel, progressMonitor));
                break;
            }
            default: {
                elements.addAll(JaxrsElementFactory.internalCreateElements(element, ast, metamodel, progressMonitor));
            }
        }
        Collections.sort(elements, new JaxrsElementsComparator());
        return elements;
    }

    private static Set<IJaxrsElement> internalCreateElements(IJavaElement scope, CompilationUnit ast, JaxrsMetamodel metamodel, IProgressMonitor progressMonitor) throws CoreException {
        if (scope.getElementType() == 3 && ((IPackageFragmentRoot)scope).isArchive()) {
            Logger.debug("Ignoring archive {}", scope.getElementName());
            return Collections.emptySet();
        }
        HashSet<IJaxrsElement> elements = new HashSet<IJaxrsElement>();
        Set<IType> matchingApplicationTypes = JavaElementsSearcher.findApplicationTypes(scope, progressMonitor);
        for (IType type : matchingApplicationTypes) {
            JaxrsJavaApplication application = JaxrsJavaApplication.from((IJavaElement)type).withMetamodel(metamodel).build();
            if (application == null) continue;
            elements.add(application);
        }
        Set<IType> matchingHttpMethodTypes = JavaElementsSearcher.findHttpMethodTypes(scope, progressMonitor);
        for (IType type : matchingHttpMethodTypes) {
            JaxrsHttpMethod httpMethod = JaxrsHttpMethod.from((IJavaElement)type).withMetamodel(metamodel).build();
            if (httpMethod == null) continue;
            elements.add(httpMethod);
        }
        Set<IType> matchingNameBindingsTypes = JavaElementsSearcher.findNameBindingTypes(scope, progressMonitor);
        for (IType type : matchingNameBindingsTypes) {
            JaxrsNameBinding nameBinding = JaxrsNameBinding.from((IJavaElement)type).withMetamodel(metamodel).build();
            if (nameBinding == null) continue;
            elements.add(nameBinding);
        }
        Set<IType> matchingResourceTypes = JavaElementsSearcher.findResourceTypes(scope, progressMonitor);
        for (IType type : matchingResourceTypes) {
            JaxrsResource resource = JaxrsResource.from((IJavaElement)type, metamodel.findAllHttpMethodNames()).withMetamodel(metamodel).build();
            if (resource == null) continue;
            elements.add(resource);
            elements.addAll(resource.getAllMethods());
            elements.addAll(resource.getAllFields());
        }
        Set<IType> matchingParamConverterProviderTypes = JavaElementsSearcher.findParamConverterProviderTypes(scope, progressMonitor);
        for (IType type : matchingParamConverterProviderTypes) {
            JaxrsParamConverterProvider paramConverterProvider = JaxrsParamConverterProvider.from((IJavaElement)type).withMetamodel(metamodel).build();
            if (paramConverterProvider == null) continue;
            elements.add(paramConverterProvider);
        }
        Set<IType> matchingParameterAggregatorTypes = JavaElementsSearcher.findParameterAggregatorTypes(scope, progressMonitor);
        for (IType type : matchingParameterAggregatorTypes) {
            JaxrsParameterAggregator parameterAggregator = JaxrsParameterAggregator.from((IJavaElement)type).buildInMetamodel(metamodel);
            if (parameterAggregator == null) continue;
            elements.add(parameterAggregator);
            elements.addAll(parameterAggregator.getAllProperties());
            elements.addAll(parameterAggregator.getAllFields());
        }
        Set<IType> matchingProviderTypes = JavaElementsSearcher.findProviderTypes(scope, progressMonitor);
        for (IType type : matchingProviderTypes) {
            JaxrsProvider provider = JaxrsProvider.from((IJavaElement)type).withMetamodel(metamodel).build();
            if (provider == null) continue;
            elements.add(provider);
        }
        return elements;
    }

    private static Set<IJaxrsElement> createElements(IMethod javaMethod, CompilationUnit ast, JaxrsMetamodel metamodel, IProgressMonitor progressMonitor) throws CoreException {
        Map<String, Annotation> methodAnnotations = JdtUtils.resolveAllAnnotations((IMember)javaMethod, ast);
        HashSet<IJaxrsElement> elements = new HashSet<IJaxrsElement>();
        if (JaxrsParamAnnotations.matchesAtLeastOne(methodAnnotations.keySet())) {
            IType parentType = (IType)javaMethod.getAncestor(7);
            IJaxrsElement parentElement = metamodel.findElement((IJavaElement)parentType);
            if (parentElement == null) {
                elements.addAll(JaxrsElementFactory.internalCreateElements((IJavaElement)parentType, ast, metamodel, progressMonitor));
            } else if (parentElement.getElementKind().getCategory() == EnumElementCategory.PARAMETER_AGGREGATOR) {
                JaxrsParameterAggregator parentParameterAggregator = (JaxrsParameterAggregator)parentElement;
                JaxrsParameterAggregatorProperty parameterAggregatorMethod = JaxrsParameterAggregatorProperty.from(javaMethod, ast).buildInParentAggregator(parentParameterAggregator);
                if (parameterAggregatorMethod != null) {
                    elements.add(parameterAggregatorMethod);
                }
            } else if (parentElement.getElementKind().getCategory() == EnumElementCategory.RESOURCE) {
                JaxrsResource parentResource = (JaxrsResource)parentElement;
                JaxrsResourceProperty resourceProperty = JaxrsResourceProperty.from(javaMethod, ast).buildInResource(parentResource);
                if (resourceProperty != null) {
                    elements.add(resourceProperty);
                }
            }
        } else if (CollectionUtils.hasIntersection(methodAnnotations.keySet(), metamodel.findAllHttpMethodNames()) || methodAnnotations.keySet().contains("javax.ws.rs.Path")) {
            IType parentType = (IType)javaMethod.getAncestor(7);
            IJaxrsElement parentElement = metamodel.findElement((IJavaElement)parentType);
            if (parentElement == null) {
                elements.addAll(JaxrsElementFactory.internalCreateElements((IJavaElement)parentType, ast, metamodel, progressMonitor));
            } else if (parentElement.getElementKind().getCategory() == EnumElementCategory.RESOURCE) {
                JaxrsResource parentResource = (JaxrsResource)parentElement;
                JaxrsResourceMethod resourceMethod = JaxrsResourceMethod.from(javaMethod, ast, metamodel.findAllHttpMethodNames()).buildInResource(parentResource);
                if (resourceMethod != null) {
                    elements.add(resourceMethod);
                }
            }
        }
        return elements;
    }

    private static Set<IJaxrsElement> createElements(IField javaField, CompilationUnit ast, JaxrsMetamodel metamodel, IProgressMonitor progressMonitor) throws CoreException {
        JaxrsParameterAggregatorField parameterAggregatorField;
        Map<String, Annotation> fieldAnnotations = JdtUtils.resolveAllAnnotations((IMember)javaField, ast);
        if (!JaxrsParamAnnotations.matchesAtLeastOne(fieldAnnotations.keySet())) {
            return Collections.emptySet();
        }
        HashSet<IJaxrsElement> elements = new HashSet<IJaxrsElement>();
        IType parentType = (IType)javaField.getAncestor(7);
        IJaxrsElement parentElement = metamodel.findElement((IJavaElement)parentType);
        if (parentElement == null) {
            elements.addAll(JaxrsElementFactory.internalCreateElements((IJavaElement)parentType, ast, metamodel, progressMonitor));
        } else if (parentElement.getElementKind().getCategory() == EnumElementCategory.RESOURCE) {
            JaxrsResourceField resourceField = JaxrsResourceField.from(javaField, ast).withMetamodel(metamodel).build();
            if (resourceField != null) {
                elements.add(resourceField);
            }
        } else if (parentElement.getElementKind().getCategory() == EnumElementCategory.PARAMETER_AGGREGATOR && (parameterAggregatorField = JaxrsParameterAggregatorField.from(javaField, ast).buildInParentAggregator((JaxrsParameterAggregator)parentElement)) != null) {
            elements.add(parameterAggregatorField);
        }
        return elements;
    }

    public static Set<IJaxrsElement> createElements(IAnnotation javaAnnotation, CompilationUnit ast, JaxrsMetamodel metamodel, IProgressMonitor progressMonitor) throws CoreException {
        if (javaAnnotation != null) {
            switch (javaAnnotation.getParent().getElementType()) {
                case 7: {
                    return JaxrsElementFactory.internalCreateElements((IJavaElement)((IType)javaAnnotation.getParent()), ast, metamodel, progressMonitor);
                }
                case 9: {
                    return JaxrsElementFactory.createElements((IMethod)javaAnnotation.getParent(), ast, metamodel, progressMonitor);
                }
                case 8: {
                    return JaxrsElementFactory.createElements((IField)javaAnnotation.getParent(), ast, metamodel, progressMonitor);
                }
            }
        }
        return Collections.emptySet();
    }
}

