/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.internal.ansi;

import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.internal.ansi.AbstractCommand;
import org.jboss.tools.aesh.core.internal.ansi.CommandType;

public class CursorPosition
extends AbstractCommand {
    private int line;
    private int column = 0;

    public CursorPosition(String arguments) {
        int i = arguments.indexOf(59);
        if (i != -1) {
            this.line = Integer.valueOf(arguments.substring(0, i)) - 1;
            this.column = Integer.valueOf(arguments.substring(i + 1)) - 1;
        } else if (arguments.length() > 0) {
            this.line = Integer.valueOf(arguments) - 1;
        }
    }

    @Override
    public CommandType getType() {
        return CommandType.CURSOR_POSITION;
    }

    @Override
    public void handle(Document document) {
        int offset = document.getLineOffset(this.line);
        int maxColumn = document.getLineLength(this.line);
        document.moveCursorTo(offset += Math.min(maxColumn, this.column));
    }
}

