/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IArtifactCollector;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.IExporter;
import org.jboss.tools.hibernate.runtime.spi.IGenericExporter;
import org.jboss.tools.hibernate.runtime.spi.IHbm2DDLExporter;
import org.jboss.tools.hibernate.runtime.spi.IQueryExporter;

public abstract class AbstractExporterFacade
extends AbstractFacade
implements IExporter {
    public AbstractExporterFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public void setConfiguration(IConfiguration configuration) {
        if (configuration instanceof IFacade) {
            Util.invokeMethod(this.getTarget(), "setConfiguration", new Class[]{this.getConfigurationClass()}, new Object[]{((IFacade)configuration).getTarget()});
        }
    }

    public void setProperties(Properties properties) {
        Util.invokeMethod(this.getTarget(), "setProperties", new Class[]{Properties.class}, new Object[]{properties});
    }

    public void setArtifactCollector(IArtifactCollector collector) {
        if (collector instanceof IFacade) {
            Util.invokeMethod(this.getTarget(), "setArtifactCollector", new Class[]{this.getArtifactCollectorClass()}, new Object[]{((IFacade)collector).getTarget()});
        }
    }

    public void setOutputDirectory(File file) {
        Util.invokeMethod(this.getTarget(), "setOutputDirectory", new Class[]{File.class}, new Object[]{file});
    }

    public void setTemplatePath(String[] strings) {
        Util.invokeMethod(this.getTarget(), "setTemplatePath", new Class[]{String[].class}, new Object[]{strings});
    }

    public void start() {
        Util.invokeMethod(this.getTarget(), "start", new Class[0], new Object[0]);
    }

    public Properties getProperties() {
        return (Properties)Util.invokeMethod(this.getTarget(), "getProperties", new Class[0], new Object[0]);
    }

    public IGenericExporter getGenericExporter() {
        IGenericExporter result = null;
        if (this.getGenericExporterClass().isAssignableFrom(this.getTarget().getClass())) {
            result = this.getFacadeFactory().createGenericExporter(this.getTarget());
        }
        return result;
    }

    public IHbm2DDLExporter getHbm2DDLExporter() {
        IHbm2DDLExporter result = null;
        if (this.getHbm2DDLExporterClass().isAssignableFrom(this.getTarget().getClass())) {
            result = this.getFacadeFactory().createHbm2DDLExporter(this.getTarget());
        }
        return result;
    }

    public IQueryExporter getQueryExporter() {
        IQueryExporter result = null;
        if (this.getQueryExporterClass().isAssignableFrom(this.getTarget().getClass())) {
            result = this.getFacadeFactory().createQueryExporter(this.getTarget());
        }
        return result;
    }

    public void setCustomProperties(Properties props) {
        assert (this.getHibernateConfigurationExporterClass().isAssignableFrom(this.getTarget().getClass()));
        Util.invokeMethod(this.getTarget(), "setCustomProperties", new Class[]{Properties.class}, new Object[]{props});
    }

    public void setOutput(StringWriter stringWriter) {
        assert (this.getHibernateConfigurationExporterClass().isAssignableFrom(this.getTarget().getClass()));
        Util.invokeMethod(this.getTarget(), "setOutput", new Class[]{Writer.class}, new Object[]{stringWriter});
    }

    protected Class<?> getConfigurationClass() {
        return Util.getClass(this.getConfigurationClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getConfigurationClassName() {
        return "org.hibernate.cfg.Configuration";
    }

    protected Class<?> getHibernateConfigurationExporterClass() {
        return Util.getClass(this.getHibernateConfigurationExporterClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getHibernateConfigurationExporterClassName() {
        return "org.hibernate.tool.hbm2x.QueryExporter";
    }

    protected Class<?> getArtifactCollectorClass() {
        return Util.getClass(this.getArtifactCollectorClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getArtifactCollectorClassName() {
        return "org.hibernate.tool.hbm2x.ArtifactCollector";
    }

    protected Class<?> getGenericExporterClass() {
        return Util.getClass(this.getGenericExporterClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getGenericExporterClassName() {
        return "org.hibernate.tool.hbm2x.GenericExporter";
    }

    protected Class<?> getHbm2DDLExporterClass() {
        return Util.getClass(this.getHbm2DDLExporterClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getHbm2DDLExporterClassName() {
        return "org.hibernate.tool.hbm2x.Hbm2DDLExporter";
    }

    protected Class<?> getQueryExporterClass() {
        return Util.getClass(this.getQueryExporterClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getQueryExporterClassName() {
        return "org.hibernate.tool.hbm2x.QueryExporter";
    }
}

