/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.runtime.spi.ITable;

public abstract class AbstractDatabaseCollectorFacade
extends AbstractFacade
implements IDatabaseCollector {
    private HashMap<String, List<ITable>> qualifierEntries = null;

    public AbstractDatabaseCollectorFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public Iterator<Map.Entry<String, List<ITable>>> getQualifierEntries() {
        if (this.qualifierEntries == null) {
            this.initializeQualifierEntries();
        }
        return this.qualifierEntries.entrySet().iterator();
    }

    private void initializeQualifierEntries() {
        this.qualifierEntries = new HashMap();
        Iterator origin = (Iterator)Util.invokeMethod(this.getTarget(), "getQualifierEntries", new Class[0], new Object[0]);
        while (origin.hasNext()) {
            Map.Entry entry = (Map.Entry)origin.next();
            ArrayList<ITable> list = new ArrayList<ITable>();
            for (Object table : (List)entry.getValue()) {
                list.add(this.getFacadeFactory().createTable(table));
            }
            this.qualifierEntries.put((String)entry.getKey(), list);
        }
    }
}

