/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.corext.template.java.AbstractJavaContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.calls.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.calls.rcp.templates.JavaTemplateProposal;
import org.eclipse.recommenders.internal.calls.rcp.templates.PatternRecommendation;
import org.eclipse.recommenders.internal.calls.rcp.templates.TemplateBuilder;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.swt.graphics.Image;

public class ProposalBuilder {
    private List<PatternRecommendation> patterns = Lists.newLinkedList();
    private Image icon;
    private IRecommendersCompletionContext rCtx;
    private JavaContext documentContext;
    private JavaElementResolver resolver;
    private String variableName;

    public ProposalBuilder(Image icon, IRecommendersCompletionContext rCtx, JavaElementResolver resolver, String variableName) {
        this.icon = icon;
        this.rCtx = rCtx;
        this.resolver = resolver;
        this.variableName = variableName;
        this.createDocumentContext();
    }

    private void createDocumentContext() {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin == null) {
            throw new IllegalStateException("No default JavaPlugin found.");
        }
        AbstractJavaContextType type = (AbstractJavaContextType)plugin.getTemplateContextRegistry().getContextType("java");
        JavaContentAssistInvocationContext javaContext = this.rCtx.getJavaContext();
        Region region = this.rCtx.getReplacementRange();
        int offset = 0;
        ASTNode node = (ASTNode)this.rCtx.getCompletionNode().orNull();
        offset = node instanceof CompletionOnSingleNameReference ? region.getOffset() - this.rCtx.getPrefix().length() : region.getOffset() - this.variableName.length();
        int length = Math.max(0, region.getLength() - 1);
        this.documentContext = new JavaContext((TemplateContextType)type, javaContext.getDocument(), offset, length, this.rCtx.getCompilationUnit());
        this.documentContext.setForceEvaluation(true);
    }

    public void addPattern(PatternRecommendation pattern) {
        this.patterns.add(pattern);
    }

    public List<JavaTemplateProposal> createProposals() {
        this.patterns = Recommendations.sortByRelevance(this.patterns);
        HashSet noDuplicates = Sets.newHashSet(this.patterns);
        LinkedList result = Lists.newLinkedList();
        for (PatternRecommendation pattern : noDuplicates) {
            try {
                result.add(new JavaTemplateProposal(this.createTemplate(pattern), (DocumentTemplateContext)this.documentContext, this.icon, pattern));
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_CREATE_PROPOSALS, (Throwable)e);
            }
        }
        return result;
    }

    private Template createTemplate(PatternRecommendation pattern) {
        String code = this.createTemplateCode(pattern);
        return new Template(pattern.getName(), pattern.getType().getClassName(), "java", code, false);
    }

    private String createTemplateCode(PatternRecommendation pattern) {
        TemplateBuilder tb = new TemplateBuilder();
        String receiverName = this.variableName;
        for (IMethodName method : (ImmutableSet)pattern.getProposal()) {
            if (method.isInit()) {
                receiverName = tb.appendCtor(method, this.lookupArgumentNames(method));
                tb.nl();
                continue;
            }
            tb.appendCall(method, receiverName, this.lookupArgumentNames(method));
            tb.nl();
        }
        tb.cursor();
        return tb.toString();
    }

    private String[] lookupArgumentNames(IMethodName method) {
        IMethod jdtMethod = (IMethod)this.resolver.toJdtMethod(method).orNull();
        try {
            if (jdtMethod != null) {
                return jdtMethod.getParameterNames();
            }
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_FIND_ARGUMENTS_FOR_METHODS, (Throwable)e, (Object[])new Object[]{jdtMethod});
        }
        ITypeName[] parameterTypes = method.getParameterTypes();
        String[] parameterNames = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterNames.length) {
            parameterNames[i] = "arg" + i;
            ++i;
        }
        return parameterNames;
    }
}

