/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.adapter.internal.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewPlugin;

public class Trace {
    public static byte CONFIG = 0;
    public static byte WARNING = 1;
    public static byte SEVERE = (byte)2;
    public static byte FINEST = (byte)3;
    public static byte FINER = (byte)4;
    private static final String[] levelNames = new String[]{"CONFIG   ", "WARNING  ", "SEVERE   ", "FINER    ", "FINEST   "};
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");

    private Trace() {
    }

    public static void trace(byte level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(byte level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (level == SEVERE) {
            PreviewPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.server.preview.adapter", s, t));
        }
        if (!PreviewPlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer sb = new StringBuffer("org.eclipse.wst.server.preview.adapter");
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }
}

