/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.wizard;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueWizardModel;

public class KeyValueWizardPage<T extends IKeyValueItem>
extends AbstractOpenShiftWizardPage {
    private IKeyValueWizardModel<T> model;

    public KeyValueWizardPage(IWizard wizard, IKeyValueWizardModel<T> model) {
        super(model.getTitle(), model.getDescription(), "", wizard);
        this.model = model;
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group group = new Group(parent, 0);
        group.setText(this.model.getGroupLabel());
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().hint(550, -1).align(4, 4).grab(true, true).applyTo((Control)group);
        Composite composite = new Composite((Composite)group, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(25, 25).applyTo(composite);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(String.valueOf(this.model.getKeyLabel()) + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        Text nameText = new Text(composite, 2048);
        nameText.setEditable(this.model.isKeyEditable());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)nameText);
        Binding nameBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText)).validatingAfterConvert(this.model.getKeyAfterConvertValidator())).to(BeanProperties.value((String)"key").observe(this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText(String.valueOf(this.model.getValueLabel()) + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)valueLabel);
        Text valueText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)valueText);
        Binding valeuBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)valueText)).validatingAfterConvert(this.model.getValueAfterConvertValidator())).to(BeanProperties.value((String)"value").observe(this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)valeuBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
    }
}

