/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.wizard;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public abstract class AbstractOpenShiftWizardPage
extends WizardPage {
    private DataBindingContext dbc;

    protected AbstractOpenShiftWizardPage(String title, String description, String pageName, IWizard wizard) {
        super(pageName);
        this.setWizard(wizard);
        this.setTitle(title);
        this.setDescription(description);
        this.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
    }

    public void createControl(Composite parent) {
        this.dbc = new DataBindingContext();
        this.setupWizardPageSupport(this.dbc);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        Composite child = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)child);
        this.setControl((Control)container);
        this.initPageChangedListener();
        this.doCreateControls(child, this.dbc);
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)15, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected void initPageChangedListener() {
        IWizardContainer wizardContainer = this.getContainer();
        if (wizardContainer instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (event.getSelectedPage() == AbstractOpenShiftWizardPage.this) {
                        AbstractOpenShiftWizardPage.this.onPageActivated(AbstractOpenShiftWizardPage.this.dbc);
                    } else {
                        AbstractOpenShiftWizardPage.this.onPageDeactivated(AbstractOpenShiftWizardPage.this.dbc);
                    }
                }
            });
            ((WizardDialog)this.getContainer()).addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(PageChangingEvent event) {
                    if (event.getTargetPage() == AbstractOpenShiftWizardPage.this) {
                        if (event.getCurrentPage() == null || event.getCurrentPage().equals(AbstractOpenShiftWizardPage.this.getPreviousPage())) {
                            AbstractOpenShiftWizardPage.this.onPageWillGetActivated(Direction.FORWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                        } else {
                            AbstractOpenShiftWizardPage.this.onPageWillGetActivated(Direction.BACKWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                        }
                    } else if (event.getCurrentPage() == AbstractOpenShiftWizardPage.this) {
                        if (event.getTargetPage() == null || event.getTargetPage().equals(AbstractOpenShiftWizardPage.this.getNextPage())) {
                            AbstractOpenShiftWizardPage.this.onPageWillGetDeactivated(Direction.FORWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                        } else {
                            AbstractOpenShiftWizardPage.this.onPageWillGetDeactivated(Direction.BACKWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                        }
                    }
                }
            });
        }
    }

    protected DataBindingContext getDatabindingContext() {
        return this.dbc;
    }

    protected void onPageActivated(DataBindingContext dbc) {
    }

    protected void onPageDeactivated(DataBindingContext dbc) {
    }

    protected void onPageWillGetActivated(Direction direction, PageChangingEvent event, DataBindingContext dbc) {
    }

    protected void onPageWillGetDeactivated(Direction progress, PageChangingEvent event, DataBindingContext dbc) {
    }

    protected abstract void doCreateControls(Composite var1, DataBindingContext var2);

    protected DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    public static enum Direction {
        FORWARDS{

            @Override
            public IWizardPage getFollowingPage(IWizardPage page) {
                return page.getNextPage();
            }
        }
        ,
        BACKWARDS{

            @Override
            public IWizardPage getFollowingPage(IWizardPage page) {
                return page.getPreviousPage();
            }
        };


        public abstract IWizardPage getFollowingPage(IWizardPage var1);
    }
}

