/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;

public class DateTimeUtils {
    private static long NANOSECONDS_PER_SEC = 1000000L;

    private DateTimeUtils() {
    }

    public static String formatDuration(long nanoseconds) {
        String[] parts = DurationFormatUtils.formatDuration((long)(nanoseconds / NANOSECONDS_PER_SEC), (String)"H:m:s:S").split(":");
        StringBuilder builder = new StringBuilder();
        if (Integer.valueOf(parts[0]) > 0) {
            builder.append(parts[0]).append(" hrs.");
        }
        if (Integer.valueOf(parts[1]) > 0) {
            builder.append(" ").append(parts[1]).append(" min.");
        }
        if (Integer.valueOf(parts[2]) > 0) {
            builder.append(" ").append(parts[2]).append(" sec.");
        }
        if (builder.length() == 0) {
            builder.append("Now");
        }
        return builder.toString().trim();
    }

    public static String formatSince(String value) {
        return DateTimeUtils.formatSince(value, null);
    }

    public static String formatSince(String value, TimeZone timezone) {
        try {
            Date date = DateTimeUtils.parse(value);
            DateFormat formatter = DateFormat.getDateTimeInstance(3, 0);
            if (timezone != null) {
                formatter.setTimeZone(timezone);
            }
            return formatter.format(date);
        }
        catch (ParseException e) {
            OpenShiftCommonUIActivator.getDefault().getLogger().logWarning("Unable to parse format duration value: " + value, (Throwable)e);
            return value;
        }
    }

    public static Date parse(String value) throws ParseException {
        String modValue = String.valueOf(value.substring(0, value.length() - 1)) + "GMT-00:00";
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        return parser.parse(modValue);
    }
}

