/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.explorer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizard;

public class OpenShiftExplorerView
extends CommonNavigator
implements IConnectionsRegistryListener {
    private Control connectionsPane;
    private Control explanationsPane;
    private PageBook pageBook;

    protected Object getInitialInput() {
        return ConnectionsRegistrySingleton.getInstance();
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        new OpenShiftExplorerContextsHandler(viewer);
        return viewer;
    }

    public void dispose() {
        ConnectionsRegistrySingleton.getInstance().removeListener((IConnectionsRegistryListener)this);
        super.dispose();
    }

    public void connectionAdded(IConnection connection) {
        this.showConnectionsOrExplanations();
    }

    private void showConnectionsOrExplanations() {
        this.asyncShowConnectionsOrExplanations();
    }

    private void asyncShowConnectionsOrExplanations() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenShiftExplorerView.this.showConnectionsOrExplanations(OpenShiftExplorerView.this.connectionsPane, OpenShiftExplorerView.this.explanationsPane);
            }
        });
    }

    public void connectionRemoved(IConnection connection) {
        this.asyncShowConnectionsOrExplanations();
    }

    public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        super.createPartControl((Composite)this.pageBook);
        this.connectionsPane = this.getCommonViewer().getControl();
        this.explanationsPane = this.createExplanationPane(this.connectionsPane, this.pageBook, toolkit);
        this.showConnectionsOrExplanations(this.connectionsPane, this.explanationsPane);
        ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)this);
    }

    private Control createExplanationPane(Control connectionsPane, PageBook pageBook, FormToolkit kit) {
        Form form = kit.createForm((Composite)pageBook);
        Composite composite = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Link link = new Link(composite, 0);
        link.setText("No connections are available. Create a new connection with the <a>New Connection Wizard...</a>");
        link.setBackground(pageBook.getDisplay().getSystemColor(25));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)this.onExplanationClicked(connectionsPane, (Control)link));
        return form;
    }

    private SelectionAdapter onExplanationClicked(final Control connectionsPane, final Control explanationPane) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizard wizard = new ConnectionWizard();
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    OpenShiftExplorerView.this.showConnectionsOrExplanations(connectionsPane, explanationPane);
                }
            }
        };
    }

    private void showConnectionsOrExplanations(Control connectionsPane, Control explanationsPane) {
        if (ConnectionsRegistrySingleton.getInstance().getAll().size() < 1) {
            this.showPage(explanationsPane);
        } else {
            this.showPage(connectionsPane);
        }
    }

    private void showPage(final Control page) {
        this.connectionsPane.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                OpenShiftExplorerView.this.pageBook.showPage(page);
            }
        });
    }

    private static class Contexts {
        private IContextActivation contextActivation;

        private Contexts() {
        }

        public void activate(String contextId) {
            this.deactivateCurrent();
            IContextService service = this.getService();
            this.contextActivation = service.activateContext(contextId);
        }

        public void deactivateCurrent() {
            if (this.contextActivation != null) {
                IContextService service = this.getService();
                service.deactivateContext(this.contextActivation);
            }
        }

        private IContextService getService() {
            return (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        }
    }

    private static class OpenShiftExplorerContextsHandler
    extends Contexts {
        private static final String CONNECTION_CONTEXT = "org.jboss.tools.openshift.explorer.context.connection";

        OpenShiftExplorerContextsHandler(CommonViewer viewer) {
            viewer.getControl().addFocusListener((FocusListener)this.onFocusLost());
            viewer.addSelectionChangedListener(this.onSelectionChanged());
        }

        private FocusAdapter onFocusLost() {
            return new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    this.deactivateCurrent();
                }
            };
        }

        private ISelectionChangedListener onSelectionChanged() {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    event.getSelection();
                    this.activate(OpenShiftExplorerContextsHandler.CONNECTION_CONTEXT);
                }
            };
        }
    }
}

