/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.application.importoperation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.AbstractProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.ImportFailedException;

public class MavenProjectImportOperation
extends AbstractProjectImportOperation {
    private static final String POM_FILE = "pom.xml";
    private Collection<String> filters;

    public MavenProjectImportOperation(File projectFolder) {
        super(projectFolder);
    }

    public void setFilters(Collection<String> filters) {
        this.filters = filters;
    }

    public List<IProject> importToWorkspace(IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
        IProjectConfigurationManager configurationManager = mavenPlugin.getProjectConfigurationManager();
        MavenModelManager modelManager = mavenPlugin.getMavenModelManager();
        Set<MavenProjectInfo> projectInfos = this.getMavenProjects(this.getProjectDirectory(), this.filters, modelManager, monitor);
        ProjectImportConfiguration projectImportConfiguration = new ProjectImportConfiguration();
        List importResults = configurationManager.importProjects(projectInfos, projectImportConfiguration, monitor);
        return this.validate(this.toProjects(importResults));
    }

    private List<IProject> toProjects(List<IMavenProjectImportResult> importResults) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IMavenProjectImportResult importResult : importResults) {
            IProject project = importResult.getProject();
            if (project == null) continue;
            projects.add(importResult.getProject());
        }
        return projects;
    }

    private List<IProject> validate(List<IProject> projects) {
        if (projects.size() == 0) {
            throw new ImportFailedException(NLS.bind((String)"There was a maven related error that prevented us from importing the project. We encourage you to look into the pom in the cloned repository at {0}.\n One of the possible reasons is that there is already a project in your workspace that matches the maven name of the OpenShift application. You can then rename your workspace project and start over again.\n", (Object)this.getProjectDirectory()), new Object[0]);
        }
        return projects;
    }

    private Set<MavenProjectInfo> getMavenProjects(File directory, Collection<String> filters, MavenModelManager modelManager, IProgressMonitor monitor) throws InterruptedException {
        if (filters == null || filters.isEmpty()) {
            return this.scan(directory, modelManager, monitor);
        }
        LinkedHashSet<MavenProjectInfo> projectInfos = new LinkedHashSet<MavenProjectInfo>();
        for (String path : filters) {
            File dir = new File(directory, path);
            projectInfos.addAll(this.scan(dir, modelManager, monitor));
        }
        return projectInfos;
    }

    private Set<MavenProjectInfo> scan(File directory, MavenModelManager modelManager, IProgressMonitor monitor) throws InterruptedException {
        LocalProjectScanner scanner = new LocalProjectScanner(directory.getParentFile(), directory.toString(), false, modelManager);
        scanner.run(monitor);
        return this.collectProjects(scanner.getProjects());
    }

    public boolean isMavenProject() {
        File root = this.getProjectDirectory();
        if (this.filters == null || this.filters.isEmpty()) {
            return this.isMavenProject(root);
        }
        for (String path : this.filters) {
            File dir = new File(root, path);
            if (!this.isMavenProject(dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isMavenProject(File dir) {
        if (!this.isReadable(dir) || !dir.isDirectory()) {
            return false;
        }
        return this.isReadable(new File(dir, POM_FILE));
    }

    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }
}

