/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.InterruptibleTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeInterruptibleTransformerWrapper<I, O>
implements InterruptibleTransformer<I, O> {
    private final InterruptibleTransformer<? super I, ? extends O> transformer;
    private final ExceptionHandler exceptionHandler;
    private final O exceptionOutput;

    public SafeInterruptibleTransformerWrapper(InterruptibleTransformer<? super I, ? extends O> transformer, ExceptionHandler exceptionHandler, O exceptionOutput) {
        if (transformer == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.exceptionHandler = exceptionHandler;
        this.exceptionOutput = exceptionOutput;
    }

    @Override
    public O transform(I input) throws InterruptedException {
        try {
            return this.transformer.transform(input);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
            return this.exceptionOutput;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.transformer);
    }
}

