/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyIterator;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private final HashBag<E> bag = new HashBag();

    public SetCollectionValueModel(CollectionValueModel<? extends E> collectionHolder) {
        super(collectionHolder);
    }

    public SetCollectionValueModel(ListValueModel<E> listHolder) {
        this(new ListCollectionValueModelAdapter<E>(listHolder));
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.bag.uniqueIterator());
    }

    @Override
    public int size() {
        return this.bag.uniqueCount();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.bag, this.collectionModel);
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.bag.clear();
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        ArrayList addedItems = new ArrayList(event.getItemsSize());
        int uniqueCount = this.bag.uniqueCount();
        for (Object item : this.getItems(event)) {
            this.bag.add(item);
            if (this.bag.uniqueCount() <= uniqueCount) continue;
            uniqueCount = this.bag.uniqueCount();
            addedItems.add(item);
        }
        this.fireItemsAdded("values", addedItems);
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        ArrayList removedItems = new ArrayList(event.getItemsSize());
        int uniqueCount = this.bag.uniqueCount();
        for (Object item : this.getItems(event)) {
            if (this.bag.remove(item)) {
                if (this.bag.uniqueCount() >= uniqueCount) continue;
                uniqueCount = this.bag.uniqueCount();
                removedItems.add(item);
                continue;
            }
            throw new IllegalStateException("missing item: " + item);
        }
        this.fireItemsRemoved("values", removedItems);
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.clearCollection(this.bag, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.bag.clear();
        CollectionTools.addAll(this.bag, this.collectionModel);
        this.fireCollectionChanged("values", new HashSet<E>(this.bag));
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }
}

