/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.beans.Introspector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedSet;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameTools {
    private static final String[] JAVA_RESERVED_WORDS_ARRAY = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    public static final SortedSet<String> JAVA_RESERVED_WORDS = Collections.unmodifiableSortedSet(CollectionTools.sortedSet((Comparable[])JAVA_RESERVED_WORDS_ARRAY));

    public static String uniqueName(String rootName, Iterable<String> existingNames) {
        return NameTools.uniqueName(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueName(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueName(rootName, existingNames, rootName);
    }

    public static String uniqueNameIgnoreCase(String rootName, Iterable<String> existingNames) {
        return NameTools.uniqueNameIgnoreCase(rootName, CollectionTools.set(existingNames));
    }

    public static String uniqueNameIgnoreCase(String rootName, Collection<String> existingNames) {
        return NameTools.uniqueName(rootName, NameTools.convertToLowerCase(existingNames), rootName.toLowerCase());
    }

    private static String uniqueName(String rootName, Collection<String> existingNames, String templateName) {
        if (!existingNames.contains(templateName)) {
            return rootName;
        }
        String uniqueName = templateName;
        int suffix = 2;
        while (existingNames.contains(String.valueOf(uniqueName) + suffix)) {
            ++suffix;
        }
        return rootName.concat(String.valueOf(suffix));
    }

    private static HashSet<String> convertToLowerCase(Collection<String> strings) {
        HashSet<String> result = new HashSet<String>(strings.size());
        for (String string : strings) {
            result.add(string.toLowerCase());
        }
        return result;
    }

    public static String buildQualifiedName(String ... segments) {
        StringBuilder sb = new StringBuilder(100);
        boolean next = false;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (next) {
                sb.append('.');
            }
            if (segment != null) {
                next = true;
                sb.append(segment);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static boolean consistsOfJavaIdentifierCharacters(String string) {
        int len = string.length();
        return len != 0 && NameTools.consistsOfJavaIdentifierCharacters(string, len);
    }

    private static boolean consistsOfJavaIdentifierCharacters(String string, int len) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int i = len;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean consistsOfJavaIdentifierCharacters(char[] string) {
        int len = string.length;
        return len != 0 && NameTools.consistsOfJavaIdentifierCharacters(string, len);
    }

    private static boolean consistsOfJavaIdentifierCharacters(char[] string, int len) {
        if (!Character.isJavaIdentifierStart(string[0])) {
            return false;
        }
        int i = len;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalJavaIdentifier(String string) {
        return NameTools.consistsOfJavaIdentifierCharacters(string) && !JAVA_RESERVED_WORDS.contains(string);
    }

    public static boolean isLegalJavaIdentifier(char[] string) {
        return NameTools.consistsOfJavaIdentifierCharacters(string) && !JAVA_RESERVED_WORDS.contains(new String(string));
    }

    public static String convertToJavaIdentifier(String string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static String convertToJavaIdentifier(String string, char c) {
        if (string.length() == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS.contains(string)) {
            NameTools.checkCharIsJavaIdentifierPart(c);
            return NameTools.convertToJavaIdentifier(String.valueOf(string) + c, c);
        }
        char[] array = string.toCharArray();
        return NameTools.convertToJavaIdentifier_(array, c) ? new String(array) : string;
    }

    public static char[] convertToJavaIdentifier(char[] string) {
        return NameTools.convertToJavaIdentifier(string, '_');
    }

    public static char[] convertToJavaIdentifier(char[] string, char c) {
        if (string.length == 0) {
            return string;
        }
        if (JAVA_RESERVED_WORDS.contains(new String(string))) {
            NameTools.checkCharIsJavaIdentifierPart(c);
            return NameTools.convertToJavaIdentifier(ArrayTools.add(string, c), c);
        }
        char[] copy = (char[])string.clone();
        return NameTools.convertToJavaIdentifier_(copy, c) ? copy : string;
    }

    private static boolean convertToJavaIdentifier_(char[] string, char c) {
        boolean mod = false;
        if (!Character.isJavaIdentifierStart(string[0])) {
            NameTools.checkCharIsJavaIdentifierStart(c);
            string[0] = c;
            mod = true;
        }
        NameTools.checkCharIsJavaIdentifierPart(c);
        int i = string.length;
        while (i-- > 1) {
            if (Character.isJavaIdentifierPart(string[i])) continue;
            string[i] = c;
            mod = true;
        }
        return mod;
    }

    private static void checkCharIsJavaIdentifierStart(char c) {
        if (!Character.isJavaIdentifierStart(c)) {
            throw new IllegalArgumentException("invalid Java identifier start char: '" + c + '\'');
        }
    }

    private static void checkCharIsJavaIdentifierPart(char c) {
        if (!Character.isJavaIdentifierPart(c)) {
            throw new IllegalArgumentException("invalid Java identifier part char: '" + c + '\'');
        }
    }

    public static String convertGetterOrSetterMethodNameToPropertyName(String methodName) {
        int beginIndex = 0;
        int len = methodName.length();
        if (methodName.startsWith("get") && len > 3) {
            beginIndex = 3;
        } else if (methodName.startsWith("set") && len > 3) {
            beginIndex = 3;
        } else if (methodName.startsWith("is") && len > 2) {
            beginIndex = 2;
        } else {
            return methodName;
        }
        return Introspector.decapitalize(methodName.substring(beginIndex));
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

