/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.ui.util.composites.FilesetPreviewComposite;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;

public class FilesetComposite
extends Composite {
    private IFilesetCompositeErrorDisplay errorDisplay;
    protected Fileset fileset;
    private String name;
    private String dir;
    private String includes;
    private String excludes;
    private Button browse;
    private Text includesText;
    private Text excludesText;
    private Text folderText;
    private Text nameText;
    private FilesetPreviewComposite preview;
    private IServer server;
    private boolean showViewer = true;
    private boolean requiresName = true;
    private Job loadPreviewJob;

    public FilesetComposite(Composite parent, Fileset fileset, boolean showViewer) {
        this(parent, fileset, showViewer, true);
    }

    public FilesetComposite(Composite parent, Fileset fileset, boolean showViewer, boolean requiresName) {
        super(parent, 0);
        this.fileset = (Fileset)fileset.clone();
        this.server = fileset.getServer();
        this.showViewer = showViewer;
        this.requiresName = requiresName;
        this.createArea(parent);
    }

    public void setErrorDisplay(IFilesetCompositeErrorDisplay d) {
        this.errorDisplay = d;
    }

    protected String getDefaultIncludesPattern() {
        return "**/*.xml";
    }

    public void setShowViewer(boolean val) {
        this.showViewer = val;
    }

    protected void createArea(Composite parent) {
        this.setLayout((Layout)new GridLayout(3, false));
        this.fillArea(this);
        if (this.requiresName) {
            this.nameText.setText(this.fileset.getName());
        }
        this.folderText.setText(this.fileset.getRawFolder());
        this.includesText.setText(this.fileset.getIncludesPattern());
        this.excludesText.setText(this.fileset.getExcludesPattern());
        this.addListeners();
        this.getShell().layout();
        this.textModified();
        this.updatePreview();
    }

    protected void addListeners() {
        ModifyListener mListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesetComposite.this.textModified();
            }
        };
        if (this.requiresName) {
            this.nameText.addModifyListener(mListener);
        }
        this.folderText.addModifyListener(mListener);
        this.includesText.addModifyListener(mListener);
        this.excludesText.addModifyListener(mListener);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(new Shell());
                String txt = FilesetComposite.this.folderText.getText();
                if (!new Path(txt).isAbsolute() && FilesetComposite.this.server != null && FilesetComposite.this.server.getRuntime() != null) {
                    txt = FilesetComposite.this.server.getRuntime().getLocation().append(txt).toString();
                }
                d.setFilterPath(txt);
                String x = d.open();
                if (x != null) {
                    FilesetComposite.this.folderText.setText(FilesetComposite.this.makeRelative(x));
                }
            }
        });
    }

    protected String makeRelative(String path) {
        if (this.server != null && this.server.getRuntime() != null && this.server.getRuntime().getLocation().isPrefixOf((IPath)new Path(path))) {
            String p2 = path.substring(this.server.getRuntime().getLocation().toString().length());
            return new Path(p2).makeRelative().toString();
        }
        return path;
    }

    protected void textModified() {
        if (this.requiresName) {
            this.name = this.nameText.getText();
        }
        this.dir = this.folderText.getText();
        this.includes = this.includesText.getText();
        this.excludes = this.excludesText.getText();
        this.fileset.setName(this.name);
        boolean requiresPreviewUpdate = false;
        requiresPreviewUpdate |= this.dir != null && !this.dir.equals(this.fileset.getRawFolder());
        requiresPreviewUpdate |= this.includes != null && !this.includes.equals(this.fileset.getIncludesPattern());
        boolean bl = this.excludes != null && !this.excludes.equals(this.fileset.getExcludesPattern());
        this.fileset.setFolder(this.dir);
        this.fileset.setIncludesPattern(this.includes);
        this.fileset.setExcludesPattern(this.excludes);
        if (requiresPreviewUpdate |= bl) {
            this.updatePreview();
        }
        if (this.errorDisplay != null) {
            this.errorDisplay.updateError(this.getValidationError());
        }
    }

    public String getValidationError() {
        String error = null;
        error = this.requiresName && this.name.equals("") ? Messages.FilesetsDialogEmptyName : (this.dir.equals("") ? Messages.FilesetsDialogEmptyFolder : null);
        return error;
    }

    protected void fillArea(Composite main) {
        if (this.requiresName) {
            Label nameLabel = new Label(main, 0);
            nameLabel.setText(Messages.FilesetsNewName);
            this.nameText = new Text(main, 2048);
            this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        Label folderLabel = new Label(main, 0);
        folderLabel.setText(Messages.FilesetsNewRootDir);
        this.folderText = new Text(main, 2048);
        this.folderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.browse = new Button(main, 8);
        this.browse.setText(Messages.FilesetsNewBrowse);
        Label includesLabel = new Label(main, 0);
        includesLabel.setText(Messages.FilesetsNewIncludes);
        this.includesText = new Text(main, 2048);
        this.includesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label excludeLabel = new Label(main, 0);
        excludeLabel.setText(Messages.FilesetsNewExcludes);
        this.excludesText = new Text(main, 2048);
        this.excludesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.showViewer) {
            Group previewWrapper = new Group(main, 0);
            previewWrapper.setLayout((Layout)new GridLayout());
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            data.minimumHeight = 200;
            previewWrapper.setLayoutData((Object)data);
            previewWrapper.setText(Messages.FilesetsNewPreview);
            previewWrapper.setLayout((Layout)new FillLayout());
            this.preview = new FilesetPreviewComposite((Composite)previewWrapper, 0);
        }
    }

    private void updatePreview() {
        if (this.preview != null) {
            String resInc = this.fileset.getResolvedIncludesPattern();
            String resExc = this.fileset.getResolvedExclude();
            this.launchPreviewJob(this.fileset.getFolder(), resInc, resExc);
        }
    }

    private synchronized void launchPreviewJob(String folder, final String inc, final String exc) {
        if (this.loadPreviewJob != null) {
            this.loadPreviewJob.cancel();
        }
        this.loadPreviewJob = new Job("Previewing matched fileset path"){

            protected IStatus run(IProgressMonitor monitor) {
                final IPath[] matched = FilesetComposite.findPaths(FilesetComposite.this.fileset.getFolder(), inc, exc, monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FilesetComposite.this.preview != null && !FilesetComposite.this.preview.isDisposed()) {
                            FilesetComposite.this.preview.setInput((Object[])matched);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.loadPreviewJob.schedule();
    }

    public String getDir() {
        return this.dir;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getName() {
        return this.name;
    }

    public Fileset getFileset() {
        return this.fileset;
    }

    private static IPath[] findPaths(String dir, String includes, String excludes, IProgressMonitor monitor) {
        return Fileset.findPaths(dir, includes, excludes, monitor);
    }

    public static interface IFilesetCompositeErrorDisplay {
        public void updateError(String var1);
    }
}

